class ChildModel {
  String id;
  String name;
  String gender;
  String fullName;
  String gradeTypeId;
  String? photo;
  ChildModel({
    required this.id,
    required this.name,
    required this.fullName,
    required this.gender,
    required this.gradeTypeId,
    this.photo,
  });

  factory ChildModel.fromJson(Map<String, dynamic> json) => ChildModel(
      id: json['id'].toString(),
      name: json['name'],
      gender: json['gender'],
      fullName: json['full_name'] ?? '',
      gradeTypeId: json['grade_type_id'].toString(),
      photo: json['photo'] ?? '');

  static List<ChildModel> fromJsonList(
    Map<String, dynamic> json,
    String key,
  ) {
    List<ChildModel> children = [];

    if (json[key] == null) {
      return [];
    }

    try {
      json[key].forEach(
        (child) => children.add(
          ChildModel.fromJson(child),
        ),
      );
    } catch (e) {
      print(e);
    }

    return children;
  }

  Map<String, dynamic> toJson() => {
        'id': id,
        'name': name,
        'gender': gender,
        'grade_type_id': gradeTypeId,
        'photo': photo,
        'full_name': fullName,
      };

static List<Map<String, dynamic>> toJsonList(List<ChildModel> children) {
    List<Map<String, dynamic>> jsons = [];
    for (var element in children) {
      jsons.add(element.toJson());
    }
    return jsons;
  }

  bool compare(ChildModel childModel) {
    if (id == childModel.id) {
      return true;
    } else if (name == childModel.name) {
      return true;
    } else if (gradeTypeId == childModel.gradeTypeId) {
      return true;
    } else {
      return false;
    }
  }
}
