import 'package:flutter/material.dart';
import '../../../common/constant/colors.dart';
import '../../../common/extensions/widget.dart';

class CircularProgressIndicatorWidget extends StatelessWidget {
  final double? size;
  final Color? color;
  const CircularProgressIndicatorWidget({super.key, this.size , this.color});

  @override
  Widget build(BuildContext context) {
    return Transform.scale(
      scale: size ?? 0.7,
      child: CircularProgressIndicator(
        color: color?? AppColors.primeColor,
        strokeWidth: 3,
      ).center(),
    );
  }
}
