import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../constant/colors.dart';

class CustomButtonDropDown extends StatefulWidget {
  const CustomButtonDropDown({Key? key}) : super(key: key);

  @override
  State<CustomButtonDropDown> createState() => _CustomButtonDropDownState();
}

class _CustomButtonDropDownState extends State<CustomButtonDropDown> {
  var items = [
    "All Notes".tr,
    "Medical notes".tr,
    "Study Notes".tr,
    "Psychological note".tr
  ];
  var selectItem;

  @override
  Widget build(BuildContext context) {
    return Column(
      mainAxisAlignment: MainAxisAlignment.center,
      children: [
        Container(
          padding: const EdgeInsets.only(left: 16, right: 16),
          margin: const EdgeInsets.only(top: 20, bottom: 20),
          width: Get.width * .85,
          height: 38,
          decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(25),
              border: Border.all(color: AppColors.secondaryColor)),
          child: DropdownButton(
            hint: Text(
              'All Notes',
              style: TextStyle(color: AppColors.secondaryColor),
            ),
            underline: const Divider(
              thickness: 0,
              color: Colors.transparent,
            ),
            style: TextStyle(
                fontSize: 16,
                color: AppColors.secondaryColor,
                fontWeight: FontWeight.bold),

            // hint: Text('Select Lang'),
            value: selectItem,
            icon: Icon(
              Icons.keyboard_arrow_down,
              color: AppColors.secondaryColor,
              size: 40,
            ),
            items: items.map((String items) {
              return DropdownMenuItem(
                value: items,
                child: Text(items),
              );
            }).toList(),
            // onChanged: (value) {},
            onChanged: (val) {
              // if (val == items[1]) {
              // controllerLang.ChangeLang("ar");
              // } else {
              // controllerLang.ChangeLang("en");
              // }
              setState(() {
                selectItem = val;
              });
            },
          ),
        ),
      ],
    );
  }
}
