import 'package:auto_size_text/auto_size_text.dart';
import 'package:dropdown_search/dropdown_search.dart';
import 'package:flutter/material.dart';
import '../../../common/constant/font.dart';

import '../constant/colors.dart';

class DropDownWidget<T> extends StatelessWidget {
  final List<T> item;
  final T selectItem;
  final void Function(T?) onChanged;
  final bool Function(T, T)? compareFunction;
  final String Function(T)? toStr;
  final EdgeInsets padding;
  final EdgeInsetsGeometry margin;


  const DropDownWidget(
      {super.key,
      required this.item,
      required this.selectItem,
      required this.onChanged,
      this.compareFunction,
      this.toStr,
      required this.padding,
      required this.margin
      //  required this.asyncItems
      });

  @override
  Widget build(BuildContext context) {
    return DropdownSearch<T>(
      // dropdownButtonProps: DropdownButtonProps(
      //     color: AppColors.secondaryColor,
      //     iconOpened: const Icon(
      //       Icons.arrow_drop_down,
      //       size: 45,
      //       color: Colors.transparent,
      //     ),
      //     padding: padding
      //     //  iconSize: 50
      //     ),
      popupProps: const PopupProps.menu(
        fit: FlexFit.loose,
        showSelectedItems: true,
      ),
      items: (filter, loadProps) => item,
      compareFn: compareFunction,
      itemAsString: toStr,
      decoratorProps: DropDownDecoratorProps(
        // isHovering: false,
        textAlignVertical: TextAlignVertical.center,
        textAlign: TextAlign.center,
        baseStyle: TextStyle(
          fontSize: 13,
          fontWeight: FontWeight.normal,
          fontFamily: AppFonts.alatsi,
          color: AppColors.newPrimeColor,
        ),
        decoration: InputDecoration(
          contentPadding: margin,
          helperStyle: const TextStyle(color: Colors.red),
          hintStyle: const TextStyle(color: Colors.red),
          border: InputBorder.none,
        ),
      ),
      onChanged: onChanged,
      selectedItem: selectItem,
    );
  }
}