import 'package:flutter/material.dart';
import '../../../common/constant/font.dart';
import '../../../common/widgets/text.dart';

class ScreenHeaderWidget extends StatelessWidget {
  const ScreenHeaderWidget({
    Key? key,
    required this.color,
    required this.titleString,
    this.expansionWidget = const SizedBox(height: 24),
    this.actionWidget = const SizedBox(),
  }) : super(key: key);

  final Color color;
  final String titleString;
  final Widget expansionWidget;
  final Widget actionWidget;

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 8),
      decoration: BoxDecoration(
        color: color,
        borderRadius: const BorderRadius.only(
          bottomLeft: Radius.circular(25),
          bottomRight: Radius.circular(25),
        ),
      ),
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: [
          Row(
            children: [
              InkWell(
                onTap: () {
                  Navigator.of(context).pop();
                },
                child: Container(
                  padding: const EdgeInsets.all(4),
                  decoration: BoxDecoration(
                    color: Colors.white,
                    borderRadius: BorderRadius.circular(10),
                  ),
                  child: Icon(
                    Icons.arrow_back,
                    color: color,
                  ),
                ),
              ),
              Expanded(
                child: Center(
                  child:
                  HeadTitleText(
                    titleString,
                    size: 24,
                    color: Colors.white,
                    fontFamily: AppFonts.alatsi,
                  )
                  // Text(
                  //   titleString,
                  //   style: const TextStyle(color: Colors.white, fontSize: 24, fontWeight: FontWeight.bold),
                  // ),
                ),
              ),
              actionWidget,
            ],
          ),
          expansionWidget,
        ],
      ),
    );
  }
}
