import 'package:flutter/material.dart';

import '../constant/colors.dart';

class TextFieldWidget extends StatelessWidget {
  final void Function(String) onChange;
  final TextInputType keyboardType;
  const TextFieldWidget(
      {super.key, required this.onChange, required this.keyboardType});

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.symmetric(horizontal: 4, vertical: 1.5),
      // decoration: BoxDecoration(
      //     border: Border.all(
      //   color: AppColors.secondaryColor,
      // )),
      width: MediaQuery.of(context).size.width * .85,
      height: 44,
      child: TextFormField(
        cursorColor: AppColors.newPrimeColor,//Colors.grey,
        cursorHeight: 25,
        style: const TextStyle(fontSize: 20, height: 1.2),
        onChanged: onChange,
        keyboardType: keyboardType,
          decoration: InputDecoration(
              contentPadding: EdgeInsets.symmetric(vertical: MediaQuery.of(context).size.height * 0.04,horizontal: MediaQuery.of(context).size.width * 0.05),
              filled: true,
              enabledBorder: OutlineInputBorder(
                  borderRadius: BorderRadius.circular(40),
                  borderSide: const BorderSide(color: Colors.grey)
              ),
              focusedBorder: OutlineInputBorder(
                  borderRadius: BorderRadius.circular(40),
                  borderSide: const BorderSide(color: Colors.grey)
              ),
              errorBorder: OutlineInputBorder(
                  borderSide: const BorderSide(color: Colors.red),
                  borderRadius: BorderRadius.circular(20.0))
          )
        // decoration: const InputDecoration(border: InputBorder.none),
      ),
    );
  }
}
