// import 'dart:convert';
// import 'dart:io';

// import 'package:firebase_messaging/firebase_messaging.dart';
// import 'package:flutter_local_notifications/flutter_local_notifications.dart';
// import '../../../core/local%20storage/local_storage.dart';

// class FirebaseApi {

//   final _firebaseMessaging = FirebaseMessaging.instance;

//   final _androidChannel = const AndroidNotificationChannel(
//     'high_importance_channel',
//     'high Importance Notifications',
//     description: 'This channel is used for important notification',
//     importance: Importance.defaultImportance
//   );
//   final _localNotifications = FlutterLocalNotificationsPlugin();
// //@mipmap-xxxhdpi/
//   Future initLocalNotifications() async {
//     const iOS = DarwinInitializationSettings();
//     const android = AndroidInitializationSettings('launcher_icon');
//     const setting = InitializationSettings(android:  android, iOS: iOS);

//     await _localNotifications.initialize(
//       setting,
//       onDidReceiveNotificationResponse: (payload) {
//         final message = RemoteMessage.fromMap(payload as Map<String, dynamic>);
//       }
//     );

//     final platform = _localNotifications.resolvePlatformSpecificImplementation<
//       AndroidFlutterLocalNotificationsPlugin>();

//     await platform?.createNotificationChannel(_androidChannel);
//   }

//   Future initPushNotifications() async {
//     await FirebaseMessaging.instance.setForegroundNotificationPresentationOptions(
//         alert: true,
//         badge: true,
//         sound: true
//     );

//     // FirebaseMessaging.instance.getInitialMessage().then(handl);
//     FirebaseMessaging.onBackgroundMessage(handleBackgroundMessage);
//     FirebaseMessaging.onMessage.listen((message) {
//       final notification = message.notification;

//       if(notification == null) return;

//       _localNotifications.show(
//           notification.hashCode,
//           notification.title,
//           notification.body,
//           NotificationDetails(
//             android: AndroidNotificationDetails(
//               _androidChannel.id,
//               _androidChannel.name,
//               channelDescription: _androidChannel.description,
//               icon: '@drawable/launcher_icon'
//             )
//           ),
//           payload: jsonEncode(message.toMap())
//       );
//     });
//   }

//   Future<void> initNotifications() async {
//     await _firebaseMessaging.requestPermission();
    
//     // On iOS, it's safer to wait for the APNs token first
//     if (Platform.isIOS) {
//       String? apnsToken = await _firebaseMessaging.getAPNSToken();
//       if (apnsToken == null) {
//         // Wait a bit and try again if necessary
//         await Future.delayed(const Duration(seconds: 2));
//       }
//     }

//     final FCMToken = await _firebaseMessaging.getToken();
//     print('FireBase FCMToken is: $FCMToken');
    
//     LocalStorage localStorage = LocalStorage();
//     localStorage.saveFCMToken(FCMToken);
    
//     await initPushNotifications();
//     await initLocalNotifications();
//   }

// }

// Future<void> handleBackgroundMessage(RemoteMessage message) async{
//   print("Title: ${message.notification?.title}");
//   print("Body: ${message.notification?.body}");
//   print("Payload: ${message.data}");
// }
import 'dart:convert';
import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:flutter_local_notifications/flutter_local_notifications.dart';

class FirebaseApi {
  final FirebaseMessaging _firebaseMessaging =
      FirebaseMessaging.instance;

  final FlutterLocalNotificationsPlugin _localNotifications =
      FlutterLocalNotificationsPlugin();

  final AndroidNotificationChannel _androidChannel =
      const AndroidNotificationChannel(
    'high_importance_channel',
    'High Importance Notifications',
    description: 'This channel is used for important notification',
    importance: Importance.high,
  );

  /// 🔹 Permission + listeners فقط
  Future<void> initNotifications() async {
    final settings = await _firebaseMessaging.requestPermission(
      alert: true,
      badge: true,
      sound: true,
    );

    if (settings.authorizationStatus ==
        AuthorizationStatus.authorized) {
      await initLocalNotifications();
      initPushNotifications();
    }
  }

  Future<void> initLocalNotifications() async {
    const android =
        AndroidInitializationSettings('launcher_icon');
    const ios = DarwinInitializationSettings();

    const settings =
        InitializationSettings(android: android, iOS: ios);

    await _localNotifications.initialize(settings);

    final platform = _localNotifications
        .resolvePlatformSpecificImplementation<
            AndroidFlutterLocalNotificationsPlugin>();

    await platform?.createNotificationChannel(_androidChannel);
  }

  void initPushNotifications() {
    FirebaseMessaging.onMessage.listen((message) {
      final notification = message.notification;
      if (notification == null) return;

      _localNotifications.show(
        notification.hashCode,
        notification.title,
        notification.body,
        NotificationDetails(
          android: AndroidNotificationDetails(
            _androidChannel.id,
            _androidChannel.name,
            channelDescription: _androidChannel.description,
            icon: 'launcher_icon',
          ),
        ),
        payload: jsonEncode(message.toMap()),
      );
    });

    FirebaseMessaging.onBackgroundMessage(
        handleBackgroundMessage);
  }
}

Future<void> handleBackgroundMessage(
    RemoteMessage message) async {
  print('BG Title: ${message.notification?.title}');
}
