
import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:get/get.dart';
import 'package:rx_future/rx_future.dart';
import '../../../common/models/child_model.dart';
import '../../../common/widgets/snack_bar_widget.dart';
import '../../../core/local%20storage/local_storage.dart';
import '../../../features/auth/data/models/login_request.dart';
import '../../../features/auth/data/models/login_response.dart';
import '../../../features/auth/data/models/resend_request.dart';
import '../../../features/auth/data/models/resend_response.dart';
import '../../../features/auth/data/models/verify_request.dart';
import '../../../features/auth/data/models/verify_response.dart';
import '../../../features/auth/data/service/login_service.dart';
import '../../../features/auth/data/service/verify_service.dart';
import '../../../features/home/business_logic/home_controller.dart';
import '../../../core/routing/routing_manager.dart';
import '../../home/presentation/screens/home_page.dart';

enum UserState {
  Registered,
  Verified,
  New,
}

class AuthController extends GetxController {
  HomeController homeController = Get.put(HomeController());
  RxFuture<bool> authState = RxFuture(true);
  String? _token;
  String? _typeUser;
  String? get typeUser {
    LocalStorage localStorage = LocalStorage();
    return localStorage.userTypeUser;
  }
  String? get token {
    LocalStorage localStorage = LocalStorage();
    return localStorage.userToken;
  }

  RxBool isCompleted = false.obs;

  void onCompletedCode() {
    isCompleted(true);
  }

  void onChangeCode() {
    isCompleted(false);
  }

  RxBool ignoring = false.obs;
  void onIgnoring() {
    ignoring(true);
  }

  Future<void> addTokenFromLocalStorage() async {
    _token = storage.userToken;
  }

  Future<void> todoIfVerified() async {
    addTokenFromLocalStorage();
    await fillChildrenFromStorage();
    await getSelectedChild();
    Get.offAll(HomePageScreen());
  }

  Future<void> getSelectedChild() async {
    int value = await storage.readSelectedChild;
    homeController.selectedChild.value = value;
  }

  LocalStorage storage = LocalStorage();

  Future<bool> get checkUserStateRegistered async {
    var f = await storage.getUserState;
    if (f == UserState.Registered.toString()) {
      return true;
    } else {
      return false;
    }
  }

  Future<bool> get checkUserStateVerified async {
    var f = await storage.getUserState;
    if (f == UserState.Verified.toString()) {
      return true;
    } else {
      return false;
    }
  }

  LoginRequest loginRequest = LoginRequest.zero();
  LoginService loginService = LoginService();
  RxFuture<LoginResponse> loginState = RxFuture(LoginResponse.zero());

  bool get phoneNumberFilled {
    if (loginRequest.phoneNumber.isEmpty) {
      return false;
    } else {
      return true;
    }
  }

  Future<void> login() async {
    await loginState.observe(
      (_) async {
        return await loginService.login(loginRequest);
      },
      onSuccess: (value) {
        storage.saveUserState(UserState.Registered.toString());
        storage.saveUserPhoneNumber(loginRequest.phoneNumber);
        storage.saveToken(value.response.token);
        storage.saveTypeUser(value.response.typeUser);
        storage.saveUserChildren(value.response.children);
        childrens.value = value.response.children;
        _token = value.response.token;
        _typeUser = value.response.typeUser;
        Get.offAllNamed(RoutesName.homePage);
      },
      onError: (error) {
        if (error.toString() == "Unknown Error") {
          snackBarWidget('error', 'phone number not Exist');
        } else {
          snackBarWidget('error', error.toString());
        }
      },
    );
  }


  VerifyRequest verifyRequest = VerifyRequest.zero();
  RxFuture<VerifyResponse> verifyState = RxFuture(VerifyResponse.zero());
  VerifyService verifyService = VerifyService();
  RxBool onErrorVerify = false.obs;
  Future<void> verify() async {
    verifyRequest.phoneNumber = await storage.getUserPhoneNumber;

    await verifyState.observe(
      (_) async {
        return await verifyService.verify(verifyRequest);
      },
      onSuccess: (value) async {
        await storage.saveUserState(UserState.Verified.toString());
        await storage.saveToken(value.token);
        await storage.saveTypeUser(value.typeUser);
        await storage.saveUserChildren(value.children);
         
        childrens.value = value.children;
        _token = value.token;
        _typeUser = value.typeUser;
        final fcmToken =
      await FirebaseMessaging.instance.getToken();

      if (fcmToken != null) {
        print('FCM TOKEN: $fcmToken');
        await sendFCMToken(fcmToken);
      } else {
        print('⚠️ FCM Token is NULL');
      }
      
        Get.offAllNamed(RoutesName.homePage);
        isCompleted(false);
      },
      onError: (error) {
        snackBarWidget('invalid code', 'insure the code you insert');
      },
    );
  }

  ResendRequest resendRequest = ResendRequest.zero();
  RxFuture<ResendResponse> resendState = RxFuture(ResendResponse.zero());
  Future<void> resendCode() async {
    await resendState.observe(
      (_) async {
        resendRequest.phoneNumber = await storage.getUserPhoneNumber;
        return await verifyService.resendCode(resendRequest);
      },
      onSuccess: (value) {
        print(value);
      },
    );
  }

  RxList<ChildModel> childrens = <ChildModel>[].obs;
 Future<void> fillChildrenFromStorage() async {
  List<ChildModel>? userChildren = await storage.getUserChildren();
    childrens.value = userChildren;
      print('childrens: $childrens');
    }


    RxFuture<void> FCMstate = RxFuture(null);
 Future<void> sendFCMToken(String FCM) async{
   await FCMstate.observe(
       (_) async {
         return loginService.sendFCMToken(FCM);
       },
     onError: (e){
         print(e);
     }
   );
 }


}
