
import '../../../helpers/data_store.dart';
import '../../../helpers/fields_validators.dart';
import '../../../common/models/child_model.dart';
// import '../../../use_cases/auth/registration_web_service.dart';
// import '../../../use_cases/home/home_screen.dart';
import 'package:flutter/cupertino.dart';

class RegistrationNotifier extends ChangeNotifier {
  bool isLoading = false;
  // late RegistrationWebService registrationWebService = RegistrationWebService();
  // final TextEditingController phoneNumberController = TextEditingController();
  // String? validPhoneNumber;
  late PageController pageController;
  String pinCode = '';
  int currentPageIndex = 0;
  //phone Number
  String? _phoneNumber;

  TextEditingController phoneNumberController = TextEditingController();

  setPhoneNumber({required String? phoneNumber}) async {
    _phoneNumber = phoneNumber;
    await DataStore.setPhoneNumber(phoneNumber!);
    notifyListeners();
  }

  String? get phoneNumber => _phoneNumber;

  dynamic checkPhoneNumber() {
    if (_phoneNumber == null) {
      return registrationValidators[validatorenum.emptyPhoneNumber];
    }
    if (_phoneNumber!.length != 10) {
      return registrationValidators[validatorenum.phoneNumberNotValid];
    }
    if (_phoneNumber!.substring(0, 2) == '09') {
      return registrationValidators[validatorenum.valid];
    } else {
      return registrationValidators[validatorenum.phoneNumberNotValid];
    }
  }

  //password
  String? _password;
  TextEditingController passwordController = TextEditingController();

  setPassword({required String? password}) async {
    _password = password;
    await DataStore.setPassword(password!);
    notifyListeners();
  }

  String? get password => _password;

  dynamic checkPassword() {
    if (_password == null) {
      return registrationValidators[validatorenum.emptyPassword];
    }
    if (_password!.length <= 2) {
      return registrationValidators[validatorenum.shortPassword];
    }
    return registrationValidators[validatorenum.valid];
  }

  clearUserData() {
    _password = '';
    _phoneNumber = '';
    notifyListeners();
  }

  List<ChildModel> childrenList = [
    ChildModel(id: '1', name: 'name', gender: 'male', photo: 'photo', gradeTypeId: 'grade', fullName: 'fullName')
  ];
  ChildModel? _selectedChild;

  RegistrationNotifier({List<ChildModel>? childrenList}) {
    if (childrenList != null) {
      this.childrenList = childrenList;
      _selectedChild = childrenList.first;
    }
    phoneNumberController.text = '';
    pageController = PageController(
      initialPage: currentPageIndex,
    );
  }

  // user Data
  // Map<String, dynamic> userData = {
  //   "fullname": "",
  //   "phone": "",
  //   "specialisation_id": "",
  //   "university": "",
  //   "email": "",
  // };
  // setUserInfo({
  //   required String? firstname,
  //   required String? phoneNumber,
  //   required SpecializationItemModel? spec,
  //   required String? university,
  //   required String? email,
  // }) {
  //   userData = {
  //     "fullname": firstname,
  //     "phone": phoneNumber,
  //     "specialisation_id": spec!.id,
  //     "university": university,
  //     "email": email,
  //   };
  //   notifyListeners();
  // }

  ChildModel get currentSelectedChild =>
      // if(_selectedChild != childrenList.first){
      //   _selectedChild != childrenList.first;
      // }else{
      _selectedChild ?? childrenList.first;
  // }/
  // return _selectedChild!;

  set currentSelectedChild(ChildModel childModel) {
    _selectedChild = childModel;
    notifyListeners();
  }

  String getChildPhoto() {
    // log('CHILD :$currentSelectedChild ');
    // log('GENDER :${currentSelectedChild.gender} ');
    if (currentSelectedChild.gender == 'male') {
      return 'assets/Kid-3.jpg';
    } else if (currentSelectedChild.gender == 'female') {
      return 'assets/Kid-4.jpg';
    }
    return ' ';
  }

  String otherChildPhoto({required ChildModel child}) {
    // log('other name :${child.name} ');
    // log('other GENDER :${child.gender} ');
    // log('other photo :${child.photo} ');
    if (child.gender == 'male') {
      return 'assets/Kid-3.jpg';
    } else if (child.gender == 'female') {
      return 'assets/Kid-4.jpg';
    }
    return ' ';
  }

  Future<void> nextPage() async {
    await pageController.nextPage(
        duration: const Duration(milliseconds: 500), curve: Curves.easeInOutQuint);
    currentPageIndex++;
    pageController = PageController(
      initialPage: currentPageIndex,
    );
  }

  void previousPage() {
    pageController.previousPage(
        duration: const Duration(milliseconds: 500), curve: Curves.easeInOutQuint);
  }

  // Future<void> submitUserInfo({
  //   required BuildContext context,
  //   required bool onlyGetChildren,
  // }) async {
  //   // validPhoneNumber

  //   isLoading = true;
  //   notifyListeners();
    
  //   String? phoneNumber = await DataStore.getPhoneNumber();
  //   String? password = await DataStore.getPassword();
  //   log('phoneNumber $phoneNumber password : $password');
  //   ApiResponse apiResponse = await registrationWebService.submitUserInfo(
  //     phoneNumber: phoneNumber,
  //     passWord: password,
  //   );
  //   // ApiResponse apiResponse = await registrationWebService.submitPhoneNumber(phoneNumber: '0999999999');

  //   isLoading = false;
  //   notifyListeners();

  //   if (apiResponse.errorMessage != null) {
  //     UiUtils.showToast(apiResponse.errorMessage!);
  //   } else {
  //     onlyGetChildren
  //         ? null
  //         : Navigator.pushNamedAndRemoveUntil(
  //             context, HomeScreen.routeName, (route) => false);
  //     childrenList = apiResponse.data;
  //     // RoutingManager.navigateToWithReplacement(RoutingManager.home);
  //     // currentPageIndex = 1;
  //     // Future.delayed(Duration(milliseconds: 500)).then((value) => RoutingManager.navigateToWithReplacement(RoutingManager.home));
  //   }
  // }

  // Future<bool> submitVerificationCode() async {
  //   if (pinCode.isEmpty) {
  //     UiUtils.showToast('Enter_the_verification_code_please'.tr);
  //     return false;
  //   }
  //   if (pinCode.length < VerificationCodeLength) {
  //     UiUtils.showToast('Complete_the_verification_code_please'.tr);
  //     return false;
  //   }

  //   isLoading = true;
  //   notifyListeners();

  //   ApiResponse apiResponse = await registrationWebService.verifyPhone(
  //     phoneNumber: _phoneNumber.toString(),
  //     // phoneNumber: '0999999999',
  //     code: pinCode,
  //   );

  //   isLoading = false;
  //   notifyListeners();

  //   if (apiResponse.errorMessage != null) {
  //     UiUtils.showToast(apiResponse.errorMessage!);
  //     await Future.delayed(Duration(milliseconds: 500));
  //     return false;
  //   } else {
  //     await Future.delayed(Duration(milliseconds: 500));
  //     childrenList = apiResponse.data;
  //     return true;
  //   }
  // }

  // Future<bool> logoutUser() async {
  //   isLoading = true;
  //   notifyListeners();

  //   ApiResponse apiResponse = await registrationWebService.logoutUser();

  //   isLoading = false;
  //   notifyListeners();

  //   if (apiResponse.errorMessage != null) {
  //     UiUtils.showToast(apiResponse.errorMessage!);
  //     await Future.delayed(Duration(milliseconds: 500));
  //     return false;
  //   } else {
  //     await Future.delayed(Duration(milliseconds: 500));
  //     log('LOg out done');
  //     return true;
  //   }
  // }
}
