import '../../../../common/models/child_model.dart';

class VerifyResponse {
  String token;
  String typeUser;
  List<ChildModel> children;
  VerifyResponse({
    required this.token,
    required this.typeUser,
    required this.children,
  });

  factory VerifyResponse.fromJson(Map<String, dynamic> json) => VerifyResponse(
        token: json['data']['token'],
        typeUser: json['data']['type'],
        children: ChildModel.fromJsonList(json['data'], 'children'),
      );

  factory VerifyResponse.zero() => VerifyResponse(
        token: '',
        typeUser: '',
        children: [],
      );
}
