import '../../../../common/constant/apis.dart';
import '../../../../core/network/http.dart';
import '../../../../features/auth/data/models/resend_request.dart';
import '../../../../features/auth/data/models/resend_response.dart';
import '../../../../features/auth/data/models/verify_request.dart';
import '../../../../features/auth/data/models/verify_response.dart';

class VerifyService {
  Future<VerifyResponse> verify(VerifyRequest verifyRequest) async {
    Request request = Request(
      EndPoints.verify,
      RequestMethod.post,
      body: verifyRequest.toJson(),
    );
    Map<String, dynamic> response = await request.sendRequest();
    return VerifyResponse.fromJson(response);
  }

  Future<ResendResponse> resendCode(ResendRequest resendRequest) async {
    Request request = Request(
      EndPoints.resendCode,
      RequestMethod.post,
      body: resendRequest.toJson(),
    );
    Map<String, dynamic> response = await request.sendRequest();
    
    print(response);
    return ResendResponse.fromJson(response);
  }
}
