import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:intl/intl.dart';
import '../../../../common/extensions/date.dart';
import '../../../../core/local%20storage/local_storage.dart';
import '../../../../core/routing/routing_manager.dart';
import '../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../features/calender/business_logic/calender_controller.dart';
import '../../../../features/home/business_logic/home_controller.dart';
import '../../../../features/weekly_class/business_logic/new_weekly_class_controller.dart';
import '../../../purchase/purchase_notifier.dart';
import 'login.dart';

class SplashScreen extends StatelessWidget {
  SplashScreen({Key? key}) : super(key: key);
  HomeController homeController = Get.find<HomeController>();
  AuthController authController = Get.find<AuthController>();
  CalenderController calenderController = Get.put(CalenderController());
  NewWeeklyClassController newWeeklyController = Get.find<NewWeeklyClassController>();
  final  PurchaseNotifier purchaseNotifier = Get.find<PurchaseNotifier>();
  String date = DateFormat('yyyy-MM-dd').format(DateTime.now());
  final _firebaseMessaging = FirebaseMessaging.instance;
  void loadData() async {
    authController.fillChildrenFromStorage();
    homeController.getNotification();
    if (authController.childrens.isNotEmpty &&
        homeController.selectedChild.value < authController.childrens.length) {
      authController
          .childrens[homeController.selectedChild.value];

      await  purchaseNotifier.getBuffetCard(
          childId: authController
              .childrens[homeController.selectedChild.value].id);
      homeController.getBuffetCard(authController.childrens[homeController.selectedChild.value].id );
      homeController.getNotes(
        {
          'registration_record_id':
          authController.childrens[homeController.selectedChild.value].id,
          'from_date': DateFormat('yyyy-MM-dd').format(DateTime.now()),
          'to_date': DateFormat('yyyy-MM-dd').format(DateTime.now()),
        },
      );
      homeController.getLatestExam({
        'registration_record_id':
        authController.childrens[homeController.selectedChild.value].id,
        'from': DateFormat('yyyy-MM-dd').format(DateTime.now())
      });
      calenderController.homeworkDelivery(
        authController.childrens[homeController.selectedChild.value].id,
        dueFrom: DateTime.now().toString().substring(0, 10),
      );
      await newWeeklyController.getSubjectTable(
          authController.childrens[homeController.selectedChild.value].id,
          date: DateTime.parse(date).toDay().toLowerCase().toString());
      // await _firebaseMessaging.requestPermission();
      // final FCMToken = await _firebaseMessaging.getToken();
      // await authController.sendFCMToken(FCMToken as String);
    }
  }

  @override
  Widget build(BuildContext context) {
    
    String? token = LocalStorage().userToken;
    Future.delayed(
      const Duration(seconds: 2),
      () async {
        print("*-*-*-*-*-*- From Splash Screen *-*-*-*-*-");
        print("Tokeeeen ${authController.token}");
        if (token != null) {
          loadData();
          Get.offAllNamed(RoutesName.homePage);
        } else {
          Get.offAll(LogIn());
        }
      },
    );
    return Container(
      decoration: BoxDecoration(
          color:  Color.fromRGBO(238, 238, 238, 1),
          image: DecorationImage(
              image: AssetImage('asset/images/backGroundLogIn1.png'),
              fit: BoxFit.cover)
              ),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        drawerEdgeDragWidth: 0.0,
        drawerEnableOpenDragGesture: false,
        body: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            Center(child: Image.asset('asset/images/bahlool.png')),
          ],
        ),
      ),
    );
  }
}