import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../common/constant/colors.dart';
import '../../../../common/widgets/circular_progress_indicator.dart';
import '../../../../common/widgets/ignore.dart';
import '../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../features/auth/presentation/widgets/button.dart';
import '../../../../common/widgets/text.dart';

import '../../../../common/extensions/widget.dart';
import '../widgets/logo.dart';
import '../widgets/p_input.dart';

class VerificationCode extends StatelessWidget {
  final AuthController authController = Get.put(AuthController());
  VerificationCode({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        resizeToAvoidBottomInset: false,
        body: Padding(
          padding: const EdgeInsets.only(top: 29),
          child: Column(
            children: [
              Column(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  const Logo(),
                  const SizedBox(
                    height: 40,
                  ),
                  HeadTitleText(
                    "Pleas inter the code".tr,
                    color: AppColors.secondaryColor,
                  ),
                ],
              ).padding(padding: const EdgeInsets.only(top: 30)),
              Column(
                children: [
                  Padding(
                    padding: const EdgeInsets.only(bottom: 25, top: 8),
                    child: PinPutWidget(
                      onCompleted: (value) {
                        authController.onCompletedCode();
                        print(value);
                      },
                      onChanged: (value) {
                        if (value.length != 6) {
                          authController.onChangeCode();
                        }
                        authController.verifyRequest.verifyCode = value;
                      },
                    ),
                  ),
                  TextTitle(
                    "if you didn't get the code press on ".tr,
                    textColor: Colors.black26,
                  ),
                  Obx(() {
                    return authController.resendState.loading
                        ? const CircularProgressIndicatorWidget()
                        : ButtonWidget(
                            title: 'Resend Code'.tr,
                            onTap: () {
                              authController.resendCode();
                            },
                            backGroundColor: Colors.transparent,
                            textColor: AppColors.secondaryColor,
                          ).padding(padding: const EdgeInsets.only(top: 4));
                  })
                ],
              ).padding(padding: const EdgeInsets.only(top: 2)).expanded(1),
              Column(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Obx(() {
                    return authController.verifyState.loading
                        ? const CircularProgressIndicatorWidget()
                        : IgnoreWidget(
                            ignoring: !authController.isCompleted.value,
                            child: ButtonWidget(
                                    title: 'OK'.tr,
                                    backGroundColor: authController
                                            .isCompleted.isFalse
                                        ? AppColors.primeColor.withOpacity(0.5)
                                        : AppColors.primeColor,
                                    onTap: () {
                                      authController.verify();
                                    })
                                .padding(
                                    padding: const EdgeInsets.only(top: 25)),
                          );
                  }),
                  Container(
                    color: AppColors.secondaryColor,
                    width: double.infinity,
                    height: 50,
                  ),
                ],
              ).expanded(1)
            ],
          ),
        ));
  }
}
