import 'package:flutter/material.dart';
import '../../../../common/constant/font.dart';
import '../../../../common/widgets/text.dart';

class ButtonWidget extends StatelessWidget {
  final String title;
  final VoidCallback onTap;
  final Color? backGroundColor;
  final Color? textColor;
  final bool isLoading;
  const ButtonWidget({
    super.key,
    required this.title,
    required this.onTap,
    this.backGroundColor,
    this.textColor,
    this.isLoading = false, 
  });

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: isLoading ? null : onTap,
      child: Container(
        decoration: BoxDecoration(
          color: backGroundColor ?? const Color(0xffa5302b),
          borderRadius: const BorderRadius.all(
            Radius.circular(40),
          ),
        ),
        // height: 50,
        // width: 165,
        alignment: Alignment.center,
        child: isLoading
            ? SizedBox(
                height: 20,
                width: 20,
                child: CircularProgressIndicator(
                  color: textColor ?? Colors.white,
                  strokeWidth: 4,
                ),
              )
            : HeadTitleText(
          title,
          size: 20,
          fontFamily: AppFonts.alatsi,
          color: textColor,

        ),
      ),
    );
  }
}
