import 'package:flutter/material.dart';
import 'package:pinput/pinput.dart';

import '../../../../common/constant/colors.dart';

class PinPutWidget extends StatelessWidget {
  final void Function(String)? onCompleted;
  final void Function(String)? onChanged;

  const PinPutWidget(
      {super.key, required this.onCompleted, required this.onChanged});

  @override
  Widget build(BuildContext context) {
    final defaultPinTheme = PinTheme(
      margin: const EdgeInsets.symmetric(horizontal: 2),
      width: 40,
      height: 40,
      textStyle: const TextStyle(
        fontSize: 17,
        color: Color.fromRGBO(30, 60, 87, 1),
        fontWeight: FontWeight.w600,
      ),
      decoration: BoxDecoration(
        color: Colors.transparent,
        border: Border.all(color: AppColors.secondaryColor),
      ),
    );
    return Column(
      children: [
        Pinput(
          onCompleted: onCompleted,
          onChanged: onChanged,
          defaultPinTheme: defaultPinTheme,
          length: 6,
          // separator: Container(
          //   margin: const EdgeInsets.symmetric(horizontal: 2),
          //   width: 10,
          //   height: 3,
          //   color: Colors.grey,
          // ),
        ),
        Container(
          margin: const EdgeInsets.symmetric(horizontal: 2),
          width: 10,
          height: 3,
          color: Colors.grey,
        )
      ],
    );
  }
}