import 'dart:io';

import 'package:device_info_plus/device_info_plus.dart';
import 'package:get/get.dart';
import 'package:path_provider/path_provider.dart';
import 'package:permission_handler/permission_handler.dart';
import 'package:rx_future/rx_future.dart';
import '../../../../common/widgets/snack_bar_widget.dart';
import '../../../../features/calender/data/models/homework_details_model.dart';
import '../../../../features/calender/data/models/subject_response.dart';
import '../../../../features/calender/data/services/home_work_service.dart';
import '../../../../features/calender/data/services/subjects_service.dart';

import '../data/models/check_absent_model.dart';
import '../data/models/homework_model.dart';
import '../data/services/absent_service.dart';

class CalenderController extends GetxController {
  // get subjects **********************************

  RxFuture<List<SubjectResponse>> subjectState = RxFuture([]);
  SubjectService subjectService = SubjectService();
  Future<void> getSubjects(String gradeId) async {
    await subjectState.observe(
      (_) async {
        return subjectService.getSubjects(gradeId);
      },
      onError: (p0) {
        snackBarWidget('something wrong', p0.toString());
      },
    );
  }

  HomeWorkService homeWorkService = HomeWorkService();
  RxFuture<List<HomeWorkModel>> homeworkState = RxFuture(<HomeWorkModel>[]);

  Future<void> getHomework(String registrationRecordId,
      {String? dueFrom, String? dueTo}) async {
         Future.delayed(
      Duration(seconds: 1),
      ()async{
    await homeworkState.observe((p0) async {
      return await homeWorkService.getHomework(registrationRecordId,
          dueFrom: dueFrom, dueTo: dueTo);
    });
    }
    );
      
  }

  RxFuture<List<HomeWorkModel>> lastHomeworkState = RxFuture(<HomeWorkModel>[]);

  Future<void> lastHomework(String registrationRecordId,
      {String? createdFrom, String? createdTo}) async {
         Future.delayed(
      Duration(seconds: 1),
      ()async{
    await lastHomeworkState.observe((p0) async {
      return await homeWorkService.lastHomework(registrationRecordId,
          createdFrom: createdFrom, createdTo: createdTo);
    });
    }
    );
      
  }

  RxFuture<List<HomeWorkModel>> homeworkDeliveryState = RxFuture(<HomeWorkModel>[]);

  Future<void> homeworkDelivery(
    String registrationRecordId, {
    String? dueFrom,
  }) async {
    Future.delayed(
      Duration(seconds: 1),
      ()async{
    await homeworkDeliveryState.observe((p0) async {
      return await homeWorkService.homeworkDelivery(registrationRecordId,
          dueFrom: dueFrom);
    });}
    );
  }

  RxFuture<HomeWorkDetailsModel> homeworkDetailsState = RxFuture(HomeWorkDetailsModel.zero());

  Future<void> homeworkDetails(int id) async {
    await homeworkDetailsState.observe((p0) async {
      return await homeWorkService.getHomeWorkDetails(id);
    });
  }

  RxFuture<void> downloadAttachmentState = RxFuture(null);

  Future<void> downloadAttachment(int id, String name) async {
    await downloadAttachmentState.observe((p0) async {
      await homeWorkService.downloadAttachment(id, name);
    });
  }

  RxFuture<void> findAttachmentState = RxFuture(null);
  bool isfind = false;

  Future<void> findAttachmentis(int id, String name) async {
    File file = File('');

    if (Platform.isAndroid) {
      DeviceInfoPlugin deviceInfo = DeviceInfoPlugin();
      AndroidDeviceInfo androidInfo = await deviceInfo.androidInfo;
      int androidVersion = androidInfo.version.sdkInt;
      print('Android version: $androidVersion');
      if (androidVersion < 33) {
        var storageStatus = await Permission.storage.status;
        if (!storageStatus.isGranted) {
          storageStatus = await Permission.storage.status;
        } else {
          if (storageStatus.isGranted) {
            const downloadsFolderPath = '/storage/emulated/0/Download/LBBIS';
            Directory dir = Directory(downloadsFolderPath);
            file = File('${dir.path}/$name');
          }
        }
      } else {
        var status = await Permission.manageExternalStorage.request();

        if (!status.isGranted) {
          status = await Permission.manageExternalStorage.request();
        } else {
          const downloadsFolderPath = '/storage/emulated/0/Download/LBBIS';
          Directory dir = Directory(downloadsFolderPath);
          file = File('${dir.path}/$name');
        }
      }
    } else if (Platform.isIOS) {
      var status = await Permission.storage.request();
      if (!status.isGranted) {
        status = await Permission.storage.request();
      }
      if (status.isGranted) {
        Directory? dir = await getApplicationDocumentsDirectory();
        file = File('${dir.path}/$name');
      }
    }

    if (await file.exists()) {
      isfind = true;
    }
    isfind = false;
  }

  Future<void> findAttachment(int id, String name) async {
    Future.delayed(
      Duration(seconds: 1),
      ()async{
    await findAttachmentState.observe((p0) async {});
  }
    );
  }

  RxFuture<CheckAbsentModel> checkAbsentState = RxFuture(CheckAbsentModel.zero());

  CheckAbsentService checkAbsentService = CheckAbsentService();
  Future<void> checkAbsent(String date, String registrationRecordId) async {
    Future.delayed(
      Duration(seconds: 1),
      ()async{
    checkAbsentState.observe((p0) async {
      return await checkAbsentService.checkAbsent(date, registrationRecordId);
    });
    }
    );
  }
  
}
