class AttachmentModel {
  int id;
  String name;
  String path;
  String size;
  String mimetype;
  AttachmentModel(
      {required this.id,
      required this.name,
      required this.path,
      required this.size,
      required this.mimetype});

  factory AttachmentModel.zero() => AttachmentModel(id: 0,name: '',path: '',size: '',mimetype: '');


  factory AttachmentModel.fromJson(Map<String, dynamic> json) =>
      AttachmentModel(
          id: json["id"],
          name: json["name"],
          path: json["path"],
          size: json["size"].toString(),
          mimetype: json["mimetype"]);

  static List<AttachmentModel> fromJsonList(Map<String, dynamic> json) {
    List<AttachmentModel> attachments = [];
    json["attachments"].forEach(
      (element) => attachments.add(
        AttachmentModel.fromJson(element),
      ),
    );
    return attachments;
  }
}
