
import 'attachment.dart';
import 'lesson.dart';

class HomeWorkDetailsModel {
  int id;
  String title;
  String description;
  String dueTo;
  String createdAt;
  List<AttachmentModel> attachments;
  LessonModel lessonModel;
  HomeWorkDetailsModel(
      {required this.id,
      required this.title,
      required this.description,
      required this.dueTo,
      required this.createdAt,
      required this.attachments,
      required this.lessonModel});

  factory HomeWorkDetailsModel.fromJson(Map<String, dynamic> json) =>
      HomeWorkDetailsModel(
        id: json["id"],
        title: json["title"],
        description: json["description"],
        dueTo: json["due_to"],
        createdAt: json["created_at"],
        attachments: AttachmentModel.fromJsonList(json),
        lessonModel: LessonModel.fromJson(
          json["lesson"],
        ),
      );
  factory HomeWorkDetailsModel.zero() => HomeWorkDetailsModel(
      id: 0,
      title: '',
      description: '',
      dueTo: '',
      createdAt: '',
      attachments: [],
      lessonModel: LessonModel.zero());
  // HomeWorkModel homeWork;
  // String description;
  // List<AttachmentModel> attachmentModel;

  // HomeWorkDetailsModel({
  //   required this.homeWork,
  //   required this.description,
  //   required this.attachmentModel,
  // });
  // factory HomeWorkDetailsModel.fromJosn(Map<String, dynamic> json) =>
  //     HomeWorkDetailsModel(
  //       homeWork: HomeWorkModel.fromJson(json["data"]),
  //       description: json["description"],
  //       attachmentModel: AttachmentModel.fromJsonList(
  //         json["attachments"],
  //       ),
  //     );
  // factory HomeWorkDetailsModel.zero() => HomeWorkDetailsModel(
  //     homeWork: HomeWorkModel.zero(), description: '', attachmentModel: []);
}
