import '../../../../features/calender/data/models/subject_model.dart';

class HomeWorkModel {
  int id;
  String title;
  String dueTo;
  String createdAt;
  String description;
  SubjectModel? subject;
  HomeWorkModel(
      {
        required this.id,
        required this.title,
        required this.dueTo,
        required this.createdAt,
        required this.description,
        required this.subject
      });

  factory HomeWorkModel.fromJson(Map<String, dynamic> json) => HomeWorkModel(
        id: json["id"],
        title: json["title"],
        dueTo: json["due_to"],
        createdAt: json["created_at"],
        description: json["description"],
        subject: json["subject"] != null
            ? SubjectModel.fromJson(json["subject"])
            : null,
      );

  static List<HomeWorkModel> fromJsonList(Map<String, dynamic> json) {
    List<HomeWorkModel> homeWorks = [];
    json["homeworks"]
        .forEach((element) => homeWorks.add(HomeWorkModel.fromJson(element)));
    return homeWorks;
  }

  factory HomeWorkModel.zero() => HomeWorkModel(
      id: 0, title: '', dueTo: '', createdAt: '', description: '', subject: SubjectModel.zero());
}
