import '../../../../features/calender/data/models/subject_model.dart';

class LessonModel {
  int id;
  String title;
  int homeworkCount;
  int attachmentCount;
  String createdAt;
  ResponsibilityModel responsibilityModel;
  LessonModel(
      {required this.id,
      required this.title,
      required this.homeworkCount,
      required this.attachmentCount,
      required this.createdAt,
      required this.responsibilityModel});

  factory LessonModel.fromJson(Map<String, dynamic> json) => LessonModel(
      id: json["id"],
      title: json["title"],
      homeworkCount: json["homeworks_count"],
      attachmentCount: json["attachments_count"],
      createdAt: json["created_at"],
      responsibilityModel:
          ResponsibilityModel.fromJson(json["responsibility"]));

  factory LessonModel.zero() => LessonModel(
      id: 0,
      title: '',
      homeworkCount: 0,
      attachmentCount: 0,
      createdAt: '',
      responsibilityModel: ResponsibilityModel.zero());

  static List<LessonModel> fromJsonList(Map<String, dynamic> json) {
    List<LessonModel> lessons = [];
    json["lessons"].forEach(
      (element) => lessons.add(
        LessonModel.fromJson(element),
      ),
    );
    return lessons;
  }
}

class ResponsibilityModel {
  int id;
  int order;
  String day;
  TeacherModel teacherModel;
  SubjectModel subjectModel;
  EducationClass educationClass;
  String createdAt;
  ResponsibilityModel(
      {required this.id,
      required this.order,
      required this.day,
      required this.teacherModel,
      required this.subjectModel,
      required this.educationClass,
      required this.createdAt,
      });

  factory ResponsibilityModel.fromJson(Map<String, dynamic> json) =>
      ResponsibilityModel(
        id: json["id"],
        order: json["order"],
        day: json["day"],
        teacherModel: TeacherModel.fromJson(
          json["teacher"],
        ),
        educationClass: EducationClass.fromJson(json["edu_class"]),
        subjectModel: SubjectModel.fromJson(json["subject"]),
        createdAt:json["created_at"]
      );
  factory ResponsibilityModel.zero() => ResponsibilityModel(
      id: 0,
      order: 0,
      day: '',
      teacherModel: TeacherModel.zero(),
      subjectModel: SubjectModel.zero(),
      educationClass: EducationClass.zero(),
      createdAt: ''
      
      );
}

class TeacherModel {
  int id;
  String name;
  TeacherModel({required this.id, required this.name});
  factory TeacherModel.fromJson(Map<String, dynamic> json) =>
      TeacherModel(id: json["id"], name: json["name"]);
  factory TeacherModel.zero() => TeacherModel(id: 0, name: '');
}

// class SubjectModel {
//   int id;
//   String name;
//   TeacherModel(
//       {required this.id, required this.name});
// factory TeacherModel.fromJson(Map<String, dynamic> json) =>
//       TeacherModel(
//           id: json["id"], name: json["name"]);
// }

class EducationClass {
  int id;
  String name;
  EducationClass({required this.id, required this.name});
  factory EducationClass.fromJson(Map<String, dynamic> json) =>
      EducationClass(id: json["id"], name: json["name"]);

  factory EducationClass.zero() => EducationClass(id: 0, name: '');
}
