import '../../../../core/network/http.dart';

import '../../../../common/constant/apis.dart';
import '../models/check_absent_model.dart';

class CheckAbsentService {
  Future<CheckAbsentModel> checkAbsent(
      String date, String registrationRecordId) async {
    Request request = Request(
        authorized: true,
        EndPoints.checkAbsent,
        RequestMethod.get,
        queryParams: {
          "date": date,
          "registration_record_id": registrationRecordId,
        });
    Map<String, dynamic> response = await request.sendRequest();
    return CheckAbsentModel.fromJson(response["data"]);
  }
}
