import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:get/get.dart';
import 'package:intl/intl.dart';
import '../../../../common/constant/colors.dart';
import '../../../../common/constant/font.dart';
import '../../../../common/widgets/text.dart';
import '../../../../core/routing/routing_manager.dart';
import '../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../features/calender/business_logic/calender_controller.dart';
import '../../../../features/class/presentation/widgets/home_work_widget.dart';
import '../../../../features/home/business_logic/home_controller.dart';
import '../../../../features/notes/business_logic/note_controller.dart';
import '../../../../common/extensions/widget.dart';
import '../../../../common/widgets/circular_progress_indicator.dart';
import '../../../../common/widgets/Error_view.dart';
import '../../../../common/widgets/Empty_view.dart';
import '../../../exam/business_logic/exam_controller.dart';
import '../../../notes/presentation/widgets/note_body.dart';
import '../widgets/attend_widget.dart';
import '../widgets/calender_widget.dart';

class CalenderPage extends StatelessWidget {
  DateTime? dateTime;
  final CalenderController calenderController = Get.find<CalenderController>();
  final AuthController authController = Get.find<AuthController>();
  final HomeController homeController = Get.find<HomeController>();
  final NoteController noteController = Get.find<NoteController>();
  final ExamController examController = Get.find<ExamController>();
  String formattedDate = DateFormat('d MMM y').format(DateTime.now());
  CalenderPage({super.key});
  @override
  Widget build(BuildContext context) {
    calenderController.getHomework(
      authController.childrens[homeController.selectedChild.value].id,
      dueFrom: DateTime.now().toString().substring(0, 10),
      dueTo: DateTime.now().toString().substring(0, 10));
    calenderController.lastHomework(
      authController.childrens[homeController.selectedChild.value].id,
      createdFrom: DateTime.now().toString().substring(0, 10),
      createdTo: DateTime.now().toString().substring(0, 10));
    examController.getLastExams(
      authController.childrens[homeController.selectedChild.value].id,
      createdFrom: DateTime.now().toString().substring(0, 10),
      createdTo: DateTime.now().toString().substring(0, 10));
    noteController.getNotes(
      {
        'registration_record_id': authController.childrens[homeController.selectedChild.value].id,
        'from_date': DateTime.now().toString().substring(0, 10),
        'to_date': DateTime.now().toString().substring(0, 10),
      },
    );
    calenderController.checkAbsent(
      DateTime.now().toString().substring(0, 10),
      authController.childrens[homeController.selectedChild.value].id
    );
    return Container(
      decoration: const BoxDecoration(
        color: Color.fromRGBO(238, 238, 238, 1), 
        image: DecorationImage(
          image: AssetImage('asset/images/backGroundLogIn1.png'),
          fit: BoxFit.cover)
      ),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        appBar: AppBar(
          backgroundColor: Colors.transparent,
          scrolledUnderElevation: 0,
          title: Padding(
            padding: EdgeInsets.symmetric(horizontal: Get.width * .2),
            child: HeadTitleText(
              'Calender'.tr,
              color: AppColors.newPrimeColor,
              size: 20,
              fontFamily: AppFonts.alatsi,
            ),
          ),
          leading: IconButton(
            onPressed: () { Navigator.pop(context);},
            icon: Icon(Icons.arrow_back, color: AppColors.newPrimeColor,),
          ),
          actions: [
            IconButton(
              onPressed: () { RoutingManager.to(RoutesName.weeklyClass); },
              icon: Icon(Icons.calendar_month , color: AppColors.newPrimeColor,),
            )
          ],
        ),
        body: SingleChildScrollView(
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              CalenderWidget(
                onSelectionChanged: (p0) {
                  dateTime = DateTime.parse(p0.value.toString());
                  noteController.getNotes(
                    {
                      'registration_record_id': authController.childrens[homeController.selectedChild.value].id,
                      'from_date': '${dateTime!.year}-${dateTime!.month}-${dateTime!.day}',
                      'to_date': '${dateTime!.year}-${dateTime!.month}-${dateTime!.day}',
                    },
                  );
                  examController.getLastExams(
                    authController.childrens[homeController.selectedChild.value].id,
                    createdFrom: '${dateTime!.year}-${dateTime!.month}-${dateTime!.day}',
                    createdTo: '${dateTime!.year}-${dateTime!.month}-${dateTime!.day}');
                  calenderController.getHomework(
                    authController.childrens[homeController.selectedChild.value].id,
                    dueFrom: '${dateTime!.year}-${dateTime!.month}-${dateTime!.day}',
                    dueTo: '${dateTime!.year}-${dateTime!.month}-${dateTime!.day}');
                  calenderController.lastHomework(authController.childrens[homeController.selectedChild.value].id,
                    createdFrom: '${dateTime!.year}-${dateTime!.month}-${dateTime!.day}',
                    createdTo: '${dateTime!.year}-${dateTime!.month}-${dateTime!.day}');
                  calenderController.checkAbsent(
                    '${dateTime!.year}-${dateTime!.month}-${dateTime!.day}',
                    authController.childrens[homeController.selectedChild.value].id );
                },
              ).center(),
              Obx(() {
                if (calenderController.checkAbsentState.loading) {
                  return const CircularProgressIndicatorWidget();
                } else {
                  return AttendWidget(
                    checkAbsentModel: calenderController.checkAbsentState.result,
                  );
                }
              }),
              Padding(
                padding: EdgeInsets.symmetric(horizontal: Get.width * .05, vertical: Get.height * .02),
                child: Container(
                  height: Get.height * .35,
                  decoration: BoxDecoration(
                    color: Color.fromRGBO(212, 181, 179, 1),
                    borderRadius: BorderRadius.circular(15)
                  ),
                  child: Column(
                    children: [
                      Row(
                        children: [
                          Padding(
                            padding: EdgeInsets.only(
                                left: Get.width * 0.03,
                                top: Get.height * 0.03,//25,//Get.height * 0.033,
                                right: Get.width * 0.04,
                                bottom: Get.height * 0.03
                            ),
                            child: SizedBox(
                              width: Get.width * 0.15,//54,
                              height: Get.height * 0.06,//50,
                              child: const Image(
                                  image: AssetImage('asset/images/homeWork.png'))
                            ),
                          ),
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              HeadTitleText(
                                "Boosting Tasks".tr.toUpperCase(),
                                fontFamily: AppFonts.alatsi,
                                color: Colors.white,
                              ),
                              HeadTitleText(
                                formattedDate.toUpperCase(),
                                fontFamily: AppFonts.alatsi,
                                color: Colors.black,
                              )
                            ],
                          )
                        ],
                      ),
                      SizedBox(
                        width: Get.width,
                        height: Get.height * .2,
                        child: Container(
                            decoration: BoxDecoration(
                              color: const Color(0xffD4B5B3),
                              borderRadius: BorderRadius.circular(20.0),
                            ),
                            child:  Obx((){
                              if(calenderController.lastHomeworkState.loading){
                                return const CircularProgressIndicatorWidget();
                              }
                              else {
                                return calenderController.lastHomeworkState.result.isEmpty
                                    ? const EmptyView(
                                  path: "asset/images/NO-HOMEWORK.png",
                                  message: "",
                                ) : GridView.builder(
                                    shrinkWrap: true,
                                    physics: const NeverScrollableScrollPhysics(),
                                    itemCount: calenderController.lastHomeworkState.result.length ,
                                    gridDelegate:
                                    const SliverGridDelegateWithFixedCrossAxisCount(
                                      crossAxisCount: 3,
                                      childAspectRatio: 0.56),
                                    itemBuilder: (BuildContext context, index) {
                                      return HomeWorkWidget(
                                        date: calenderController.lastHomeworkState.result[index].createdAt.substring(0, 10),
                                        homeWorkModel: calenderController.lastHomeworkState.result[index],
                                      );
                                    }
                                );
                              }
                            }
                            )
                        ),
                      )
                    ],
                  ),
                ),
              ),
              Padding(
                padding: EdgeInsets.symmetric(horizontal: Get.width *.05),
                child: Container(
                  height: Get.height * .35,
                  decoration: BoxDecoration(
                      color: AppColors.quizShadow,
                      borderRadius: BorderRadius.circular(15)
                  ),
                  child: Column(
                    children: [
                      Row(
                        children: [
                          Padding(
                            padding: EdgeInsets.only(
                              left: Get.width * 0.03,
                              top: Get.height * 0.03,
                              right: Get.width * 0.04,
                              bottom: Get.height * 0.03
                            ),
                            child: SizedBox(
                              width: Get.width * 0.15,
                              height: Get.height * 0.06,
                              child: const Image(image: AssetImage('asset/images/homeWork.png'))
                            ),
                          ),
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              HeadTitleText(
                                "Delivery Day".tr,
                                fontFamily: AppFonts.alatsi,
                                color: Colors.white,
                              ),
                              HeadTitleText(
                                formattedDate.toUpperCase(),
                                fontFamily: AppFonts.alatsi,
                                color: Colors.black,
                              )
                            ],
                          )
                        ],
                      ),
                      SizedBox(
                          height: Get.height * .225,//150,
                          child: Obx(() {
                            if (calenderController.lastHomeworkState.loading) {
                              return const CircularProgressIndicatorWidget();
                            } else {
                              return calenderController.homeworkState.result.isEmpty
                                  ? const EmptyView(
                                path: "asset/images/NO-HOMEWORK.png",
                                message: "",
                              )
                                  : GridView.builder(
                                  shrinkWrap: true,
                                  physics: AlwaysScrollableScrollPhysics(),//const NeverScrollableScrollPhysics(),
                                  itemCount: calenderController.homeworkState.result.length ,
                                  gridDelegate:
                                  const SliverGridDelegateWithFixedCrossAxisCount(
                                      crossAxisCount: 3,
                                      childAspectRatio: 0.56),
                                  // scrollDirection: Axis.horizontal,
                                  itemBuilder: (BuildContext context, index) {
                                    return HomeWorkWidget(
                                      date: calenderController
                                          .homeworkState.result[index].dueTo
                                          .substring(0, 10),
                                      homeWorkModel: calenderController
                                          .homeworkState.result[index],
                                    );
                                  }
                              );
                            }
                          })),
                    ],
                  ),
                ),
              ),
              //Exam
              Padding(
                padding: EdgeInsets.symmetric(horizontal: Get.width *.05, vertical: Get.height * .02),
                child: Container(
                  height: Get.height * .35,
                  decoration: BoxDecoration(
                      color: const Color.fromRGBO(212, 181, 179, 1),//Colors.cyan,
                      borderRadius: BorderRadius.circular(15)
                  ),
                  child: Column(
                    children: [
                      Row(
                        children: [
                          Padding(
                            padding: EdgeInsets.only(
                                left: Get.width * 0.03,
                                top: Get.height * 0.03,//25,//Get.height * 0.033,
                                right: Get.width * 0.04,
                                bottom: Get.height * 0.03
                            ),
                            child: SizedBox(
                                width: Get.width * 0.15,//54,
                                height: Get.height * 0.06,//50,
                                child: const Image(
                                    image: AssetImage('asset/images/exam.png'))
                            ),
                          ),
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              HeadTitleText(
                                "Exams".tr.toUpperCase(),
                                fontFamily: AppFonts.alatsi,
                                color: Colors.white,
                              ),
                              HeadTitleText(
                                formattedDate.toUpperCase(),
                                fontFamily: AppFonts.alatsi,
                                color: Colors.black,
                              )
                            ],
                          )
                        ],
                      ),
                      Container(
                        // color: Colors.yellow,
                        height: Get.height * .225,
                        child: Obx((){
                          if(examController.lastExamState.loading){
                            return const CircularProgressIndicatorWidget();
                          }else {
                            return examController.lastExamState.result.isEmpty
                                ? const EmptyView(
                              path: "asset/images/NO-HOMEWORK.png",
                              message: "",
                            ) : GridView.builder(
                                shrinkWrap: true,
                                physics: const AlwaysScrollableScrollPhysics(),//const NeverScrollableScrollPhysics(),
                                itemCount: examController.lastExamState.result.length ,
                                gridDelegate:
                                const SliverGridDelegateWithFixedCrossAxisCount(
                                    crossAxisCount: 3,
                                    childAspectRatio: 0.56),
                                itemBuilder: (BuildContext context, index) {
                                  return Container(
                                    margin: const EdgeInsets.symmetric(horizontal: 15, vertical: 30),
                                    decoration: BoxDecoration(
                                        color: Colors.white,
                                        borderRadius: const BorderRadius.all(Radius.circular(15)),
                                        border: Border.all(color: AppColors.newPrimeColor)
                                    ),
                                    child: Column(
                                      mainAxisAlignment: MainAxisAlignment.spaceAround,
                                      crossAxisAlignment: CrossAxisAlignment.center,
                                      children: [
                                        HeadTitleText(
                                          examController.lastExamState.result[index].subjectModel.name,
                                          size: 12,
                                          color: Colors.black,
                                          fontFamily: AppFonts.alatsi,
                                        ).paddingSymmetric(horizontal: 10),
                                        HeadTitleText(
                                          examController.lastExamState.result[index].name,
                                          size: 12,
                                          color: Colors.black,
                                          fontFamily: AppFonts.alatsi,
                                        ).paddingSymmetric(horizontal: 10),
                                        HeadTitleText(
                                          "Mark: ${examController.lastExamState.result[index].maxMark}",
                                          size: 12,
                                          color: Colors.black,
                                          fontFamily: AppFonts.alatsi,
                                        ),
                                        HeadTitleText(
                                          examController.lastExamState.result[index].date,
                                          size: 12,
                                          color: Colors.black,
                                          fontFamily: AppFonts.alatsi,
                                        ).paddingSymmetric(horizontal: 10),
                                      ],
                                    ),
                                  );
                                }
                            );
                          }
                        }),
                      )
                    ],
                  ),
                ),
              ),
              const Divider(
                thickness: 1.5,
              ),
              Padding(
                padding: EdgeInsets.symmetric(horizontal: Get.width * .065),
                child: Obx(() {
                  if (noteController.notesState.loading) {
                    return SizedBox(
                      height: Get.height * 0.3,
                      width: Get.width,
                      child: const CircularProgressIndicatorWidget());
                  }
                  if (noteController.notesState.hasError) {
                    return ErrorView(onRetry: () {
                      noteController.getNotes(
                        {
                          'registration_record_id': authController.childrens[homeController.selectedChild.value].id
                        },
                       );
                    });
                  }
                  if (noteController.notesState.result.isEmpty) {
                    return SizedBox(
                        height: Get.height * 0.3,
                        width: Get.width,
                        child: const EmptyView());
                  } else {
                    return Column(
                      children: [
                        NoteBodyWidget(
                          note: noteController.notesState.result[0],
                        ).padding(padding: const EdgeInsets.only(top: 10)),
                        noteController.notesState.result.length > 1
                            ? NoteBodyWidget(
                            note: noteController.notesState.result[1]
                        ) : Container(),
                      ],
                    );
                  }
                }),
              )
            ],
          ),
        ),
      ),
    );
  }
}
