import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../common/extensions/widget.dart';
import '../../../../features/home/common/constant.dart';
import '../../../../common/constant/colors.dart';
import '../../../../common/widgets/text.dart';
import '../../../../features/calender/data/models/check_absent_model.dart';

class AttendWidget extends StatelessWidget {
  final CheckAbsentModel checkAbsentModel;
  const AttendWidget({super.key, required this.checkAbsentModel});
  @override
  Widget build(BuildContext context) {
    return Container(
        decoration: BoxDecoration(
          // color: AppColors.newPrimeColor,
          color: checkAbsentModel.status == "arrive"
              ? AppColors.appGreen.withOpacity(0.7)
              : AppColors.primeColor,
          borderRadius: BorderRadius.circular(20)
        ),
        margin: const EdgeInsets.only(top: 15),
        width: Get.width * .85,
        height: Get.height * 0.06,//50,
        alignment: Alignment.center,
        child: Row(
          children: [
            Padding(
              padding: EdgeInsets.symmetric(horizontal: Get.width * 0.03),
              child: Container(
                // color: Colors.blue,
                height: Get.height * 0.03,//22,
                width: Get.width * 0.06,//24,
                child: checkAbsentModel.status == "arrive"
                    ? Image(image: AssetImage('asset/icons/attend.png'))
                    : Icon(Icons.cancel_outlined, size: 30, color: Colors.white,),
              ),
            ),
            HeadTitleText(
              checkAbsentModel.status == "arrive" ? "Attended".tr : "Absent".tr,
              color: Colors.white,
              fontFamily: AppFonts.alatsi,
              size: 22,
            ),
          ],
        )
    ).center();
  }
}
