import 'dart:io';
import 'dart:ui';
import 'package:dio/dio.dart' as dio;
import 'package:get/get.dart';
import 'package:rx_future/rx_future.dart';
import '../../../../common/widgets/snack_bar_widget.dart';
import '../../../../core/local%20storage/local_storage.dart';
import '../../../../features/chat/data/entities/teacher_entitie.dart';
import '../../../../features/chat/data/model/mail.dart';
import '../../../../features/chat/data/model/mail_responce.dart';
import '../../../../features/chat/data/model/teacher.dart';
import '../../../../features/chat/data/source/teacher_chat_service.dart';
import '../../../../features/restaurant/data/entities/match.dart';
import 'package:file_picker/file_picker.dart';

class ChatController extends GetxController {
  int balance = 0;
  int daily_limit = 0;
  bool loading = false;
  // ------------- Data Sources -------------

  TeacherChatService TeacherRepo = TeacherChatService();

  // ------------- Rx Variables -------------

  GetTeacherEntity getTeacherRequestModel = GetTeacherEntity.zero();

  RxFuture<List<TeacherChat>> getTeacherResponseModel =
      RxFuture(<TeacherChat>[]);

  RxFuture<List<MailResponse>> getMailResponseModel =
      RxFuture(<MailResponse>[]);

  // ------------- Setters -------------

  void setRegistrationRecord(String registrationRecordId) {
    getTeacherRequestModel.registrationRecordId = registrationRecordId;
  }

  // ------------- Methods -------------
  Match match = Match.zero();

  List<TeacherChat> teachers = [];

  Future<void> getTeachers() async {
    getTeacherResponseModel.observe(
      (_) async {
        return await TeacherRepo.getTeacherChat(
          registrationRecordId: getTeacherRequestModel.registrationRecordId,
        );
      },
      onSuccess: (p0) {
        if (getTeacherResponseModel.result.isNotEmpty) {
          teachers = [];
          for (int i = 0; i < getTeacherResponseModel.result.length; i++) {
            teachers.insert(i, getTeacherResponseModel.result[i]);
          }
        }
      },
      onError: (error) {
        snackBarWidget('something wrong', error.toString());
      },
    );
  }

  List<MailResponse> mails = [];
  Future<void> getMails(int teacherId) async {
    getMailResponseModel.observe(
      (_) async {
        return await TeacherRepo.getMailChat(
            teacherId: teacherId
        );
      },
      onSuccess: (p0) {
        mails = [];
        if (getMailResponseModel.result.isNotEmpty) {
          for (int i = 0; i < getMailResponseModel.result.length; i++) {
            mails.insert(i, getMailResponseModel.result[i]);
          }
        }
      },
      onError: (error) {
        snackBarWidget('something wrong', error.toString());
      },
    );
  }

  List<String> selectedFilePaths = [];

  List<File> selectedFiles = [];

  List<dio.MultipartFile> multipartFiles = [];

  Future<void> openFilePicker() async {
    FilePickerResult? result = await FilePicker.platform.pickFiles(
      allowMultiple: true,
    );

    if (result != null) {
      List<PlatformFile> platformFiles = result.files;
      selectedFilePaths =
          platformFiles.map((platformFile) => platformFile.path!).toList();

      selectedFiles =
          selectedFilePaths.map((filePath) => File(filePath)).toList();

      for (int i = 0; i < selectedFiles.length; i++) {
        multipartFiles.add(
          await dio.MultipartFile.fromFile(
            selectedFiles[i].path,
            filename: "file$i",
          ),
        );
      }
    } else {
      // User canceled the file picker
    }
  }

  RxFuture<void> sendMailState = RxFuture(null);

  Future<void> sendMail(MailRequest mailRequest,
      {VoidCallback? onSuccess}) async {
    await sendMailState.observe((_) async {
      await TeacherRepo.sendMail(mailRequest);
    }, onSuccess: (p0) {
      onSuccess!.call();
      selectedFiles = [];
      multipartFiles = [];
    }, onError: (e) {
      if (e.toString() == 'Unknown Error') {
        snackBarWidget('', 'Can\'t send now');
      } else {
        snackBarWidget('', e.toString());
      }
    });
  }

  LocalStorage storage = LocalStorage();
  Future<void> addTokenFromLocalStorage() async {
    String? token = storage.userToken;
    print("YYYYYYYYYYYYYYYYYYYYYyy");
    print(token);
  }
}
