
import 'dart:io';
import 'package:dio/dio.dart';


class MailRequest {
  String title;
  String message;
  String type;
  List<File> files;
  int receiver_id;



  MailRequest(
      {required this.title,
      required this.message,
      required this.files,
      required this.receiver_id,
      required this.type,
      });
  factory MailRequest.zero() => MailRequest(
        title: '',
        message: '',
        type: '',
        receiver_id: 0,
        files: [],
      );

   Map<String, dynamic> toJson() => {
        "title": title,
        "message": message,
        "type": type,
        "receiver_id": receiver_id,
        "files": files,
      };

    FormData toFormData() {
          var formData = FormData.fromMap ({
              "title": title,
              "message": message,
              "type": type,
              "receiver_id": receiver_id,
          });


          return formData;
      }
}
