import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../common/constant/colors.dart';
import '../../../../common/extensions/widget.dart';
import '../../../../common/widgets/Empty_view.dart';
import '../../../../common/widgets/Error_view.dart';
import '../../../../common/widgets/circular_progress_indicator.dart';
import '../../../../common/widgets/text.dart';
import '../../../../core/routing/routing_manager.dart';
import '../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../features/chat/business_logic/chat_controller.dart';
import '../../../../features/chat/data/model/teacher.dart';
import '../../../../features/chat/presentation/widgets/chat_teacher.dart';
import '../../../../features/home/business_logic/home_controller.dart';
import '../../../../common/widgets/app_bar.dart';

class ChatTeacherPage extends StatefulWidget {

  ChatTeacherPage({super.key});

  @override
  State<ChatTeacherPage> createState() => _ChatTeacherPageState();
}

class _ChatTeacherPageState extends State<ChatTeacherPage> {
  final ChatController chatController = Get.put(ChatController());

  final AuthController authController = Get.find<AuthController>();

  final HomeController homeController = Get.find<HomeController>();

  void loadData() async {
    chatController.setRegistrationRecord(
      authController.childrens[homeController.selectedChild.value].id,
    );
    await chatController.getTeachers();
  }

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    loadData();
  }

  @override
  Widget build(BuildContext context) {
    // loadData();
    return Container(
      decoration: const BoxDecoration(
          color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
          image: DecorationImage(
              image: AssetImage('asset/images/backGroundLogIn1.png'),
              fit: BoxFit.cover)
      ),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        appBar: AppBar(
          backgroundColor: Colors.transparent,
          leading: IconButton(
            icon: const Icon(Icons.arrow_back),
            color: AppColors.newPrimeColor,
            onPressed: () {
              Navigator.pop(context);
            },
          ),
          title: Center(
            child: HeadTitleText(
              'Chat'.toUpperCase(),
              color: AppColors.newPrimeColor,
              fontFamily: 'alatsi',
            ).padding(
                padding: const EdgeInsets.only(right: 50, bottom: 10)),
          ),

        ),
        body: Padding(
          padding: const EdgeInsets.symmetric(horizontal: 10),
          child: Column(
            children: [
              SizedBox(
                  height: Get.height * 0.78,
                  child: Obx(() {
                    if (chatController.getTeacherResponseModel.loading) {
                      return const CircularProgressIndicatorWidget();
                    }
                    if (chatController.getTeacherResponseModel.hasError) {
                      return ErrorView(onRetry: () {
                        chatController.getTeachers();
                      });
                    } else {
                      return chatController.getTeacherResponseModel.result.isEmpty
                          ? Padding(
                        padding: EdgeInsets.symmetric(vertical: Get.height * .2, horizontal: Get.width * .35),
                        child: const EmptyView(),
                      )
                          : Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: [
                          Expanded(
                            child: ListView.builder(
                              itemCount: chatController.teachers.length,
                              itemBuilder: (context, index) {
                                TeacherChat teachers =
                                chatController.teachers[index];
                                return InkWell(
                                  onTap: () async {
                                    await chatController.getMails(teachers.user_id);
                                    RoutingManager.to(RoutesName.chatPage,
                                        arguments: teachers);
                                  },
                                  child: ChatTeacherCardWidget(teachers),
                                );
                              },
                            ),
                          ),
                        ],
                      );
                    }
                  })),
            ],
          ),
        ),
      ),
    );
  }
}
