import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../common/constant/colors.dart';
import '../../../../common/widgets/Empty_view.dart';
import '../../../../common/widgets/text.dart';
import '../../../../features/chat/business_logic/chat_controller.dart';
import '../../../../features/chat/data/model/mail_responce.dart';
import '../../../../features/class/presentation/widgets/attachment_widget.dart';
import '../../../../common/widgets/app_bar.dart';
import '../../../../common/widgets/circular_progress_indicator.dart';

class MailPage extends StatelessWidget {
  final ChatController chatController = Get.put(ChatController());
  MailResponse mail = Get.arguments;

  MailPage({super.key});

  void loadData() async {


  }
  @override
  Widget build(BuildContext context) {
    loadData();

    return Scaffold(
      appBar: AppBarWidget(
        title: "Message".tr,
      ),
      body: Obx(() {
        return chatController.sendMailState.loading
            ? const CircularProgressIndicatorWidget()
            : Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                TextTitle(
                  mail.title,
                  textColor: AppColors.primeColor,
                  size: 18,
                ),
                Column(
                  children: [
                    Row(
                      children: [

                        RegularText(
                          mail.date
                              .substring(0, 10)
                              .tr,
                          size: 12,
                          textColor: Colors.black.withOpacity(0.5),
                        ),
                      ],
                    ),

                  ],
                )
              ],
            ).paddingSymmetric(horizontal: 20),
            Container(
              margin: const EdgeInsets.only(top: 20),
              // alignment: Alignment.topLeft,
              child: NormalText(
                mail.message.tr,
                textColor: Colors.black,
              ),
            ).paddingSymmetric(horizontal: 20),
            const Divider(
              color: Colors.black,
            ),
            TextTitle(
              "Attachment".tr,
              textColor: AppColors.primeColor,
            ),
            SizedBox(
              height: 210,
              width: Get.width,
              child: mail.attachments.isEmpty
                  ? const EmptyView()
                  : ListView.builder(
                  shrinkWrap: true,
                  scrollDirection: Axis.horizontal,
                  itemCount: mail.attachments.length,
                  itemBuilder: (BuildContext context, index) {
                    return AttachmentWidget(
                      attachmentModel: mail
                          .attachments[index],
                    );
                  }),
            )
          ],
        ).paddingSymmetric(horizontal: 10);
      }),
    );
  }
}
