import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../common/constant/colors.dart';
import '../../../../features/chat/business_logic/chat_controller.dart';
import '../../../../features/chat/data/model/mail.dart';
import '../../../../features/chat/data/model/teacher.dart';
import '../../../../common/widgets/app_bar.dart';
import '../../../../core/routing/routing_manager.dart';
import '../../../restaurant/presentation/widgets/school_button.dart';

class NewMail extends StatelessWidget {
  final ChatController chatController = Get.put(ChatController());
  final TextEditingController _titleController = TextEditingController();
  final TextEditingController _messageController = TextEditingController();
  TeacherChat teacher = Get.arguments;
  NewMail({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBarWidget(
        title: 'New Message'.tr,
      ),
      body: Padding(
        padding: const EdgeInsets.all(16.0),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.start,
          children: <Widget>[
            TextField(
              controller: _titleController,
              decoration: const InputDecoration(labelText: 'Title'),
              style: const TextStyle(fontSize: 20.0),
            ),
            const SizedBox(height: 20),
            TextField(
              controller: _messageController,
              decoration: const InputDecoration(labelText: 'Message'),
              style: const TextStyle(fontSize: 18.0), // Change text style
              maxLines: null,
            ),
            const SizedBox(height: 20),
            // Expanded(
            //   child: ListView.builder(
            //     itemCount: chatController.selectedFiles.length,
            //     itemBuilder: (context, index) {
            //       double sizeInMb =
            //           chatController.selectedFiles[index].size / (1024 * 1024);
            //       return ListTile(
            //         title: Text(chatController.selectedFiles[index].name),
            //         subtitle: Text('${sizeInMb.toStringAsFixed(3)} MB'),
            //       );
            //     },
            //   ),
            // ),
            const SizedBox(height: 20),
            // MaterialButton(
            //   onPressed: () async {
            //     await chatController.openFilePicker();
            //
            //     // Set the _attachmentPath variable to the selected file path
            //   },
            //   child: const Text('Select Attachment'),
            // ),
            // const SizedBox(height: 20),
            Obx(() {
              return SchoolButton(
                    () async {
                  MailRequest mailRequest = MailRequest(
                      title: _titleController.text,
                      message: _messageController.text,
                      files: chatController.selectedFiles,
                      receiver_id: teacher.user_id,
                      type: "mail");
                  await chatController.sendMail(mailRequest ,
                    onSuccess: () async {
                      await chatController.getMails(teacher.user_id);
                      RoutingManager.back();
                    },
                  );
                },
                'Send Email'.tr,
                AppColors.primeColor.withOpacity(0.8),
                isLoading: chatController.sendMailState.loading,
              );
            }),

          ],
        ),
      ),
    );
  }
}
