import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../common/constant/domain.dart';
import '../../../../common/constant/colors.dart';
import '../../data/model/teacher.dart';

class ChatTeacherCardWidget extends StatelessWidget {
  final TeacherChat teacherChat;
  const ChatTeacherCardWidget(this.teacherChat, {super.key});
  @override
  Widget build(BuildContext context) {
    String words = '';
    List<String> wordL;
    String image = '';
    if (teacherChat.image != null) {
      words = teacherChat.image;
      wordL = words.split("/");
      image = wordL.sublist(1, wordL.length).join("/");
    }
    return Column(
      children: [
        SizedBox(
          height: 80,
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Container(
                child: Row(
                  
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    Padding(
                      
                      padding: const EdgeInsets.only(top: 2.0, right: 4.0),
                      child: Container(
                        height: 60.0,
                        width: 60.0,
                        decoration: BoxDecoration(
                          image: DecorationImage(
                            image: words.isEmpty
                                ? const AssetImage(
                                    'asset/images/blank-profile-picture.png')
                                : NetworkImage('${Domain.domain}storage/$image')
                                    as ImageProvider,
                            fit: BoxFit.cover,
                          ),
                          shape: BoxShape.circle,
                        ),
                      ),
                    ),
                    const SizedBox(
                      width: 15,
                    ),
                    Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          teacherChat.name.tr,
                          style: TextStyle(
                            fontSize: 15,
                            fontWeight: FontWeight.bold,
                            color: AppColors.secondaryColor,
                          ),
                        ),
                        // const SizedBox(
                        //   height: 1,
                        // ),
                        Text(
                          teacherChat.specialization,
                          style: TextStyle(
                            fontSize: 12,
                            color: AppColors.appBlack.withOpacity(0.5),
                          ),
                        ),
                      ],
                    ),
                  ],
                ),
              ),
            ],
          ),
        ),
        const Divider(
          thickness: 1,
        ),
      ],
    );
  }
}
