import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../common/constant/colors.dart';
import '../../data/model/mail_responce.dart';

class ChatMessageCardWidget extends StatelessWidget {
  final MailResponse mailResponse;
  const ChatMessageCardWidget(this.mailResponse, {super.key});
  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        SizedBox(
          height: 80,
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Container(
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                  
                    Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          mailResponse.title.tr,
                          style: TextStyle(
                            fontSize: 15,
                            fontWeight: FontWeight.bold,
                            color: AppColors.secondaryColor,
                          ),
                        ),
                        const SizedBox(
                          height: 10,
                        ),
                        Text(
                          mailResponse.date,
                          style: TextStyle(
                            fontSize: 12,
                            color: AppColors.appBlack.withOpacity(0.5),
                          ),
                        ),
                        const SizedBox(
                          height: 10,
                        ),
                        Text(
                          mailResponse.received.toString(),
                          style: TextStyle(
                            fontSize: 12,
                            color: AppColors.appBlack.withOpacity(0.5),
                          ),
                        ),
                      ],
                    ),
                  ],
                ),
              ),
            ],
          ),
        ),
        const Divider(
          thickness: 1,
        ),
      ],
    );
  }
}
