import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:get/get.dart';
import '../../../../common/constant/colors.dart';
import '../../../../common/constant/font.dart';
import '../../../../common/extensions/widget.dart';
import '../../../../common/widgets/circular_progress_indicator.dart';
import '../../../../common/widgets/Empty_view.dart';
import '../../../../common/widgets/text.dart';
import '../../../../features/class/presentation/widgets/attachment_widget.dart';
import '../../../../features/weekly_class/business_logic/new_weekly_class_controller.dart';
import '../../../../features/weekly_class/business_logic/weekly_class_controller.dart';
import '../widgets/home_work_widget.dart';

class ClassScreen extends StatelessWidget {
  final WeeklyClassController weeklyClassController = Get.find<WeeklyClassController>();
  final NewWeeklyClassController newWeeklyController = Get.find<NewWeeklyClassController>();
  ClassScreen({super.key});
  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: const BoxDecoration(
          color: Color.fromRGBO(238, 238, 238, 1), 
          image: DecorationImage(
              image: AssetImage('asset/images/backGroundLogIn1.png'),
              fit: BoxFit.cover)),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        appBar: AppBar(
          backgroundColor: Colors.transparent,
          scrolledUnderElevation: 0,
          leading: IconButton(
            icon: const Icon(Icons.arrow_back),
            color: AppColors.newPrimeColor,
            onPressed: () {
              Navigator.pop(context);
            },
          ),
          title: HeadTitleText(
            Get.arguments.toString().tr,
            color: AppColors.newPrimeColor,
            fontFamily: 'alatsi',
          ).padding(padding: EdgeInsets.symmetric(horizontal: Get.width * .25)),
        ),
        body: Obx(() {
          return newWeeklyController.lessonDetailsState.loading
              ? const CircularProgressIndicatorWidget()
              : newWeeklyController.lessonDetailsState.result.notes.isEmpty
              ? const Column(
            mainAxisAlignment: MainAxisAlignment.center, 
            crossAxisAlignment: CrossAxisAlignment.center, 
            children: [
              EmptyView(),
            ],
          ).center()
              : Container(
                child: Column(
                  children: [
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Row(
                          children: [
                            RegularText(
                              "Teacher name".tr+" ",
                              size: 14,
                            ),
                            TextTitle(
                                textColor: Colors.black,
                                size: 14,
                                "  MR.".tr),
                            TextTitle(
                                textColor: Colors.black,
                                size: 14,
                                newWeeklyController
                                    .lessonDetailsState
                                    .result
                                    .responsibilityModel
                                    .teacherModel
                                    .name
                                    .tr
                            )
                          ],
                        ),
                        Row(
                          children: [
                            RegularText(
                              "Date:".tr+" ",
                              size: 14,
                            ),
                            RegularText(
                              newWeeklyController
                                  .lessonDetailsState
                                  .result
                                  .responsibilityModel
                                  .createdAt
                                  .tr
                                  .substring(0, 10),
                              size: 14,
                            ),
                          ],
                        ),//.expanded(4),
                      ],
                    ).paddingSymmetric(horizontal: Get.width * .02,vertical: Get.height * .01),
                    //Homework
                    HeadTitleText(
                      "Boosting Tasks".tr.toUpperCase(),
                      color: AppColors.primeColor,
                      size: 20,
                      fontFamily: AppFonts.alatsi,
                    ).paddingOnly(bottom: Get.height * .01),
                    SizedBox(
                      width: Get.width,
                      height: Get.height / 4,
                      child: Padding(
                          padding: EdgeInsets.symmetric(horizontal: Get.width * .04),
                        child: Container(
                          decoration: BoxDecoration(
                            color: const Color(0xffD4B5B3),
                            borderRadius: BorderRadius.circular(20.0),
                          ),
                          child: GridView.builder(
                              shrinkWrap: true,
                              itemCount: newWeeklyController.lessonDetailsState.result.homeworks.length,
                              gridDelegate:
                              const SliverGridDelegateWithFixedCrossAxisCount(
                                  crossAxisCount: 3,
                                  childAspectRatio: 0.56),
                              itemBuilder: (BuildContext context, index) {
                                return
                                  HomeWorkWidget(
                                  homeWorkModel: newWeeklyController.lessonDetailsState.result.homeworks[0],
                                  date: newWeeklyController.lessonDetailsState.result.homeworks[0].dueTo,
                                );
                              })
                        )
                      ),
                    ).paddingOnly(bottom: Get.height * .01),
                    const Divider(
                      endIndent: 10,
                      indent: 10,
                      color: Colors.black,
                      thickness: 2,
                    ).paddingSymmetric(vertical: Get.height * .01),
                    HeadTitleText(
                      "Attachment".tr,
                      color: AppColors.primeColor,
                      size: 20,
                      fontFamily: AppFonts.alatsi,
                    ).paddingOnly(bottom: Get.height * .01),
                    SizedBox(
                      width: Get.width,
                      height: Get.height / 4,
                      child: Padding(
                        padding: EdgeInsets.symmetric(horizontal: Get.width * .04),
                        child: Container(
                          decoration: BoxDecoration(
                              gradient: const LinearGradient(
                                  begin: Alignment.centerRight,
                                  end: Alignment.topRight,
                                  colors: [
                                    Color.fromRGBO(232, 211, 211, 1),
                                    Color.fromRGBO(217, 217, 217, 1),
                                  ]),
                              borderRadius: BorderRadius.circular(20.0)),
                          child: GridView.builder(
                              shrinkWrap: true,
                              itemCount: newWeeklyController.lessonDetailsState.result.attachments.length,

                              gridDelegate:
                              SliverGridDelegateWithFixedCrossAxisCount(
                                  crossAxisCount: 3,
                                  childAspectRatio: Get.height < 700 ? 0.85 : 0.56,
                              ),

                              itemBuilder: (BuildContext context, index) {
                                return Padding(
                                  padding: EdgeInsets.only(left: Get.width * .02, right: Get.width * .02),
                                  child: AttachmentWidget(
                                    attachmentModel: newWeeklyController
                                        .lessonDetailsState
                                        .result
                                        .attachments[index],
                                  ),
                                );
                              }),
                        ),
                      ),
                    ),
                  ],
                ),
              );
        })
      ),
    );
  }
}