import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../common/constant/colors.dart';
import '../../../../common/constant/font.dart';
import '../../../../common/widgets/app_bar.dart';
import '../../../../common/widgets/circular_progress_indicator.dart';
import '../../../../common/widgets/text.dart';
import '../../../../core/routing/routing_manager.dart';
import '../../../../features/calender/data/models/homework_model.dart';

import '../../../../common/widgets/Empty_view.dart';
import '../../../calender/business_logic/calender_controller.dart';
import '../widgets/attachment_widget.dart';

class HomeworkDetailsScreen extends StatelessWidget {

  HomeworkDetailsScreen({super.key});
  final CalenderController calenderController = Get.find<CalenderController>();
  HomeWorkModel homeWorkModel = Get.arguments;

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: const BoxDecoration(
          color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
          image: DecorationImage(
              image: AssetImage('asset/images/backGroundLogIn1.png'),
              fit: BoxFit.cover)),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        appBar:AppBar(
          backgroundColor: Colors.transparent,
          title: Padding(
            padding: EdgeInsets.symmetric(horizontal: Get.width * .17),
            child: HeadTitleText(
                homeWorkModel.subject != null
                    ? homeWorkModel.subject!.name
                    : calenderController.homeworkDetailsState.result.lessonModel
                    .responsibilityModel.subjectModel.name,
              color: AppColors.newPrimeColor,
              size: 20,
              fontFamily: AppFonts.alatsi,
            ),
          ),
          leading: IconButton(
            onPressed: (){
              RoutingManager.back();
              // Navigator.pop(context);
            },
            icon: Icon(Icons.arrow_back, size: 30,color: AppColors.newPrimeColor,),
          ),
        ),
        // AppBarWidget(
        //     title: homeWorkModel.subject != null
        //         ? homeWorkModel.subject!.name
        //         : calenderController.homeworkDetailsState.result.lessonModel
        //             .responsibilityModel.subjectModel.name),
        body: Obx(() {
          return calenderController.homeworkDetailsState.loading
              ? const CircularProgressIndicatorWidget()
              : Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        // TextTitle(
                        //   calenderController.homeworkDetailsState.result.title,
                        //   textColor: AppColors.primeColor,
                        //   size: 18,
                        // ),
                        Container(
                          width: Get.width * .4,
                          child: HeadTitleText(
                                  calenderController.homeworkDetailsState.result.title,
                                  fontFamily: AppFonts.alatsi,
                                  color: AppColors.primeColor,
                                  
                                ),
                        ),
                        Column(
                          children: [
                            Row(
                              children: [
                                RegularText(
                                  'Created Date: '.tr,
                                  size: 12,
                                  textColor: Colors.black,//.withOpacity(0.5),
                                ),
                                RegularText(
                                  calenderController
                                      .homeworkDetailsState.result.createdAt.split('T').first
                                      //.substring(0, 10)
                                      .tr,
                                  size: 12,
                                  textColor: Colors.black,//.withOpacity(0.5),
                                ),
                              ],
                            ),
                            Row(
                              children: [
                                RegularText(
                                  'Delivery Date: '.tr,
                                  size: 12,
                                  textColor: Colors.black,//.withOpacity(0.5),
                                ),
                                RegularText(
                                  calenderController
                                      .homeworkDetailsState.result.dueTo.substring(0,10).tr,//split('T').first.tr,
                                  size: 12,
                                  textColor: Colors.black,//.withOpacity(0.5),
                                ),
                              ],
                            ),
                          ],
                        )
                      ],
                    ).paddingSymmetric(horizontal: 20),
                    Container(
                      margin: const EdgeInsets.only(top: 20),
                      // alignment: Alignment.topLeft,
                      child: NormalText(
                        calenderController
                            .homeworkDetailsState.result.description.tr,
                        textColor: Colors.black,
                      ),
                    ).paddingSymmetric(horizontal: 20),
                    Padding(
                      padding: EdgeInsets.symmetric(vertical: Get.height * .02),
                      child: const Divider(
                        color: Colors.black,
                      ),
                    ),
                    HeadTitleText(
                      "Attachment".tr,
                      color: AppColors.primeColor,
                      size: 25,
                      fontFamily: AppFonts.alatsi,
                    ),
                    // Attachment
                    SizedBox(
                      height: Get.height * .24,
                      width: Get.width,
                      child: calenderController
                              .homeworkDetailsState.result.attachments.isEmpty
                          ? const EmptyView()
                          : ListView.builder(
                              shrinkWrap: true,
                              scrollDirection: Axis.horizontal,
                              itemCount: calenderController
                                  .homeworkDetailsState.result.attachments.length,
                              itemBuilder: (BuildContext context, index) {
                                return AttachmentWidget(
                                  attachmentModel: calenderController
                                      .homeworkDetailsState
                                      .result
                                      .attachments[index],
                                );
                              }),
                    )
                  ],
                ).paddingSymmetric(horizontal: 10);
        }),
      ),
    );
  }
}
