import 'package:auto_size_text/auto_size_text.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../common/extensions/widget.dart';
import '../../../../common/widgets/text.dart';
import '../../../../core/routing/routing_manager.dart';
import '../../../../features/weekly_class/business_logic/new_weekly_class_controller.dart';

import '../../../../common/constant/colors.dart';
import '../../../calender/business_logic/calender_controller.dart';
import '../../../calender/data/models/homework_model.dart';
import '../../../weekly_class/data/model/lesson_details_model.dart';
import '../../../weekly_class/presentation/widgets/class_widget.dart';

class HomeWorkWidget extends StatefulWidget {

  final HomeWorkModel homeWorkModel;
  final LessonDetailsModel? lessonModel;
  Color? color;
  String date;


  HomeWorkWidget(
      {super.key, required this.homeWorkModel, this.lessonModel, this.color, required this.date});

  @override
  State<HomeWorkWidget> createState() => _HomeWorkWidgetState();
}

class _HomeWorkWidgetState extends State<HomeWorkWidget> {
  // WeeklyClassController weeklyClassController =
  final CalenderController calenderController = Get.find<CalenderController>();

  final NewWeeklyClassController newWeeklyController = Get.find<NewWeeklyClassController>();

  late final String name;

  loadData(){
    if(widget.homeWorkModel.subject == null){
      setState(() {
       name = widget.lessonModel != null ? widget.lessonModel!.title : '';
      });
    }else {
      setState(() {
        name = widget.homeWorkModel.subject!.name;
      });
    }
  }
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    loadData();
  }
  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.symmetric(horizontal: 15, vertical: 30),
      width: Get.width * 0.40,
      decoration: BoxDecoration(
        boxShadow: [
          BoxShadow(
            color: AppColors.newPrimeColor.withOpacity(0.3),
            spreadRadius: 0,
            blurRadius: 9,
          )
        ],
        color: AppColors.newPrimeColor.withOpacity(0.8),
        borderRadius: BorderRadius.circular(20.0),
      ),
      child: Stack(
        children: [
          Container(
              width: Get.width * 0.28,
              height: 60,
              decoration: const BoxDecoration(
                borderRadius: BorderRadius.only(
                  topLeft: Radius.circular(25),
                  topRight: Radius.circular(25),
                ),
              ),
              child: const Icon(
                CupertinoIcons.square_pencil,
                size: 40,
                color: CupertinoColors.white,
              )
          ),
          Column(
            mainAxisAlignment: MainAxisAlignment.end,
            children: [
              Container(
                width: Get.width * 0.3,
                height: 100,
                decoration: const BoxDecoration(
                  color: Colors.white,
                  borderRadius: BorderRadius.only(
                      topLeft: Radius.circular(15),
                      topRight: Radius.circular(15),
                      bottomLeft: Radius.circular(5),
                      bottomRight: Radius.circular(5)),
                ),
                child: Column(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      AutoSizeText(
                        name,//widget.homeWorkModel.subject!.name,
                        maxFontSize: 15,
                        minFontSize: 10,
                        maxLines: 2,
                      ).center().paddingSymmetric(horizontal: 10).expanded(2),
                      // RegularText(
                      //   homeWorkModel.subject!.name.tr,
                      //   size: 15,
                      // ).paddingSymmetric(horizontal: 10).expanded(4),
                      RegularText(
                        widget.homeWorkModel.title.tr,
                        size: 12,
                      ).center().paddingSymmetric(horizontal: 10).expanded(4),
                    ]),
              )
            ],
          ),
        ],
      ),
    )
        .onTap(() {
      RoutingManager.to(RoutesName.homeworkDetailsScreen , arguments: widget.homeWorkModel);
      calenderController.homeworkDetails(widget.homeWorkModel.id);
    })
    ;
  }
}