import 'package:get/get.dart';
import 'package:rx_future/rx_future.dart';
import '../../../../common/widgets/snack_bar_widget.dart';
import '../../../../features/calender/data/models/subject_response.dart';
import '../../../../features/exam/data/models/exam_model.dart';
import '../data/service/exams_service.dart';

class ExamController extends GetxController {
//get exams and marks ***************

  RxFuture<List<ExamModel>> examState = RxFuture([]);
  ExamService examService = ExamService();
  RxFuture<List<ExamModel>> lastExamState = RxFuture([]);
  Future<void> getExams(Map<String, dynamic> params) async {
    Future.delayed(
      Duration.zero,
      () async {
        await examState.observe(
          (_) async {
            return examService.getExams(params);
          },
          onError: (p0) {
            snackBarWidget(
              'something wrong',
              p0.toString(),
            );
          },
        );
      },
    );
  }

  Future<void> getLastExams(String registrationRecordId,
      {String? createdFrom, String? createdTo}) async{
    Future.delayed(
      Duration.zero,
          () async{
        await lastExamState.observe(
                (_) async{
              return examService.lastExam(registrationRecordId,
                  createdFrom: createdFrom, createdTo: createdTo);
            },
            onError: (p0){
              snackBarWidget(
                  'something wrong',
                  p0.toString()
              );
            }
        );
      },
    );
  }


  SubjectResponse subject = SubjectResponse.zero();

  List<String> studentSubjectNames = [];
  void fillSubjectNameForStudent() {
    studentSubjectNames.clear();
    for (var element in examState.result) {
      studentSubjectNames.add(element.subjectModel.name);
    }
  }

  RxFuture<ExamModel> singleExamState = RxFuture(ExamModel.zero());
}
