import 'package:get/get.dart';
import 'package:rx_future/rx_future.dart';
import '../../../../common/widgets/snack_bar_widget.dart';
import '../../../../features/calender/data/models/subject_response.dart';
import '../../../../features/exam/data/models/exam_model.dart';
import '../../../../features/exam/data/service/marks_service.dart';

class ResultController extends GetxController {
//get exams and marks ***************

  RxFuture<List<ExamModel>> examState = RxFuture([]);
  ResultService resultService = ResultService();
  Future<void> getExams(Map<String, dynamic> params) async {
    Future.delayed(
      // Duration.zero,
      Duration(seconds: 1),
      () async {
        await examState.observe(
          (_) async {
            return resultService.getResults(params);
          },
          onError: (p0) {
            snackBarWidget(
              'something wrong',
              p0.toString(),
            );
          },
        );
      },
    );
  }

  SubjectResponse subject = SubjectResponse.zero();

  List<String> studentSubjectNames = [];
  void fillSubjectNameForStudent() {
    studentSubjectNames.clear();
    for (var element in examState.result) {
      studentSubjectNames.add(element.subjectModel.name);
    }
  }

  RxFuture<ExamModel> singleExamState = RxFuture(ExamModel.zero());
}
