import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../common/constant/colors.dart';
import '../../../../common/widgets/Empty_view.dart';
import '../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../features/exam/business_logic/result_controller.dart';
import '../../../../features/exam/presentation/widgets/drop_down_exam.dart';
import '../../../../common/extensions/widget.dart';
import '../../../../features/home/business_logic/home_controller.dart';
import '../../../../common/widgets/rx_view.dart';
import '../../../calender/business_logic/calender_controller.dart';
import '../widgets/result_body.dart';

class ResultPage extends StatefulWidget {

  ResultPage({super.key});

  @override
  State<ResultPage> createState() => _ResultPageState();
}

class _ResultPageState extends State<ResultPage> {

  final ResultController resultController = Get.find<ResultController>();

  final AuthController authController = Get.find<AuthController>();

  final HomeController homeController = Get.find<HomeController>();

  final CalenderController calenderController = Get.find<CalenderController>();


  loadData() async{
    await calenderController.getSubjects(authController
        .childrens[homeController.selectedChild.value].id);

    await resultController.getExams({
      'registration_record_id': authController.childrens[homeController.selectedChild.value].id,
      'subject': calenderController.subjectState.result[0].id
    });
  }

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    loadData();
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: const BoxDecoration(
          color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
          image: DecorationImage(
              image: AssetImage('asset/images/backGroundLogIn1.png'),
              fit: BoxFit.cover)),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        body: Column(crossAxisAlignment: CrossAxisAlignment.center, children: [
          DropDownExam().center(),
          SizedBox(
              width: Get.width * .85,
              child: Obx(() {
                return resultController.examState.loading
                    ? Center(child: CircularProgressIndicator(
                  backgroundColor: AppColors.quizItem,
                  color: AppColors.newPrimeColor,
                ))
                    : resultController.examState.result.isEmpty
                    ? const EmptyView()
                    : ListView.builder(
                  itemCount: resultController.examState.result.length,
                  itemBuilder: (BuildContext context, index) {
                    return ResultBodyWidget(
                      examModel: resultController.examState.result[index],
                    );
                    // .onTap(() {
                    //   // RoutingManager.to(RoutesName.examDetails,arguments: );
                    // });
                  },
                );
                  RxView(
                  rxFuture: resultController.examState,
                  onRetry: () {
                    resultController.getExams({
                      'registration_record_id': authController
                          .childrens[homeController.selectedChild.value].id,
                    });
                  },
                  child: resultController.examState.result.isEmpty
                      ? const EmptyView()
                      : ListView.builder(
                          itemCount: resultController.examState.result.length,
                          itemBuilder: (BuildContext context, index) {
                            return ResultBodyWidget(
                              examModel: resultController.examState.result[index],
                            );
                            // .onTap(() {
                            //   // RoutingManager.to(RoutesName.examDetails,arguments: );
                            // });
                          },
                        ),
                );
              })).expanded(9)
        ]),
      ),
    );
  }
}
