import 'dart:convert';
import '../../../../../../features/home/common/constant.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:http/http.dart' as http;

class Api {

  // final String _url = 'http://192.168.1.10:8080/';// with local
  // final String _url = 'http://192.168.1.4:8080/';// with demo
  var _token;

  _getToken() async {
    SharedPreferences localStorage = await SharedPreferences.getInstance();
    // _token = localStorage.getString('token');
    _token = localStorage.getString('token');
  }

  gettToken() async {
    SharedPreferences localStorage = await SharedPreferences.getInstance();
    // _token = localStorage.getString('token');
    _token = localStorage.getString('token');
  }

  getTeacherData(apiUrl) async {
    var fullUrl = baseUrl + apiUrl;
    await _getToken();
    return await http.get(
        Uri.parse(fullUrl),
        headers: _setHeaders()
    );
  }

  getData(apiUrl) async {
    var fullUrl = baseUrl + apiUrl;
    await _getToken();
    return await http.get(
      Uri.parse(fullUrl),
      headers: _setHeaders()
    );
  }

  authData(data, apiUrl) async {
    var fullUrl = baseUrl + apiUrl;
    return await http.post(
        Uri.parse(fullUrl),
        body: jsonEncode(data),
        headers: _setHeadersAuth()
    );
  }

  _setHeadersAuth() => {
    'Content-type': 'application/json',
    'Accept': 'application/json',
  };

  postData(data, apiUrl) async{
    var fullUrl = baseUrl + apiUrl;
    await _getToken();
    return await http.post(
        Uri.parse(fullUrl),
        body: jsonEncode(data),
        headers: _setHeaders()
    );
  }

  _setHeaders() => {
    'Content-type': 'application/json',
    'Accept': 'application/json',
    'Authorization': 'Bearer $_token'
  };
}