import 'package:get/get.dart';
import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/extensions/widget.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../core/local%20storage/local_storage.dart';
import '../../../../../../core/routing/routing_manager.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/calender/business_logic/calender_controller.dart';
import '../../../../../../features/exam/business_logic/exam_controller.dart';
import '../../../../../../features/exam/business_logic/result_controller.dart';
import '../../../../../../features/home/business_logic/home_controller.dart';
import '../../../../../../features/home/common/constant.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:intl/intl.dart';
import '../../../../../../features/home/presentation/widgets/notification_body.dart';
import '../../../../../../features/notes/business_logic/note_controller.dart';
import '../../../../../../features/notification/business_logic/notification_controller.dart';
import '../../../../../../features/variable/business_logic/variable_controller.dart';
import '../../../../../../features/weekly_class/business_logic/new_weekly_class_controller.dart';
import '../../../../../../features/weekly_class/business_logic/weekly_class_controller.dart';
import '../../../../../../features/weekly_class/data/model/weekly_class.dart';
import '../../../../../../features/weekly_class/presentation/screens/weekly_class_screen.dart';
import '../../../../../../features/weekly_class/presentation/widgets/class_widget.dart';

import '../../../../common/widgets/circular_progress_indicator.dart';
import '../../../weekly_class/data/model/new_weekly_class.dart';

class MainScreen extends StatefulWidget {
  const MainScreen({super.key});

  @override
  State<MainScreen> createState() => _MainScreenState();
}

class _MainScreenState extends State<MainScreen> {
  NotificationController notificationController = Get.put(NotificationController());
  CalenderController calenderController = Get.put(CalenderController());
  HomeController homeController = Get.put(HomeController());
  ExamController examController = Get.find<ExamController>();
  WeeklyClassController weeklyClassController = Get.find<WeeklyClassController>();
  NewWeeklyClassController newWeeklyController = Get.find<NewWeeklyClassController>();
  AuthController authController = Get.find<AuthController>();
  NoteController noteController = Get.find<NoteController>();
  VariableController variableController = Get.put(VariableController());
  ResultController resultController = Get.find<ResultController>();
  String formattedDate = DateFormat('d MMM y').format(DateTime.now());
  String nameDay = DateFormat('EEEE').format(DateTime.now()).toLowerCase();
  String date = DateFormat('d MMM y').format(DateTime.now());
  List<DailySubject>? subjects;
  var day;
  var data;
  List<dynamic> daySchedule = [];
  String? typeUser;
  String? reg;
  // final ChangeIndexNotifier _index = ChangeIndexNotifier();

  loadData() async {
    reg = authController.childrens[homeController.selectedChild.value].id;
    await newWeeklyController.getSubjectTable(
        authController.childrens[homeController.selectedChild.value].id,
        date: nameDay);
    try{
      daySchedule = newWeeklyController
          .subjectMap[nameDay]!.subjects;
    }catch(e){
      print(e);
    }
    print("nameDay");
    print(nameDay);
    print("nameDay");
  }

  @override
  void initState() {
    super.initState();
    typeUser = LocalStorage().userTypeUser;
    loadData();
  }

  @override
  Widget build(BuildContext context) {
    return SingleChildScrollView(
      child: Column(
        children: [
          // padding:EdgeInsets.only(top: Get.height * 0.02),//15.0),
          GestureDetector(
            onTap: () async{
              // await calenderController.getSubjects(authController
              //     .childrens[homeController.selectedChild.value].id);
              RoutingManager.to(RoutesName.calenderPage);
            },
            child: Container(
              width: Get.width * 0.88,//361,
              height: Get.height * 0.3,//227,
              decoration: BoxDecoration(
                color: const Color(0xffD4B5B3),
                borderRadius: BorderRadius.circular(20.0),
              ),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Row(
                    children: [
                      Padding(
                        padding: EdgeInsets.only(
                            left: Get.width * 0.05,
                            top: Get.height * 0.033,
                            right: Get.width * 0.04,
                            bottom: Get.height * 0.03
                        ),
                        child: SizedBox(
                          width: Get.width * 0.15,//54,
                          height: Get.height * 0.050,//50,
                          child: const Image(
                              image:
                                  AssetImage('asset/images/calender1.png')),
                        ),
                      ),
                      Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          HeadTitleText(
                            "Today Summary".tr,
                            fontFamily: AppFonts.alatsi,
                            color: Colors.white,
                          ),
                          HeadTitleText(
                            formattedDate.toUpperCase(),
                            fontFamily: AppFonts.alatsi,
                            color: Colors.black,
                          )
                        ],
                      )
                    ],
                  ),
                  Obx(() {
                    if (homeController.state.loading) {
                      return const CircularProgressIndicatorWidget();
                    }
                    if (homeController.state.hasError) {
                      return InkWell(
                        onTap: () {
                          homeController.getNotification();
                        },
                        child: Text('Try again'.tr).center(),
                      );
                    }
                    if (homeController.state.result.isEmpty) {
                      return Center(
                        child: Text('No Data Available'.tr).center(),
                      );
                    } else {
                      return NotificationBody();
                    }
                  }),
                ],
              ),
            ).center().padding(padding: EdgeInsets.only(top: Get.height * 0.023)),//20)),
          ),
          GestureDetector(
            onTap: () {
              print('Weekly Schedule');
              Navigator.push(context,
                  MaterialPageRoute(builder: (context) => WeeklyClassScreen()));
            },
            child: Container(
              width: Get.width * 0.88,//361,
              height: Get.height * 0.31,//227,
              decoration: BoxDecoration(
                  gradient: const LinearGradient(
                      begin: Alignment.centerRight,
                      end: Alignment.topRight,
                      colors: [
                        Color.fromRGBO(232, 211, 211, 1),
                        Color.fromRGBO(217, 217, 217, 1),
                      ]),
                  borderRadius: BorderRadius.circular(20.0)),
              child: Column(
                children: [
                  Row(
                    children: [
                      Padding(
                        padding: EdgeInsets.only(
                            left: Get.width * 0.05,
                            top: Get.height * 0.033,
                            right: Get.width * 0.04,
                            bottom: Get.height * 0.03
                        ),
                        child: SizedBox(
                          width: Get.width * 0.15,//54,
                          height: Get.height * 0.06,//50,
                          child: SvgPicture.asset(
                            'asset/days/${nameDay.toLowerCase()}.svg',
                            semanticsLabel: 'My SVG Image',
                            // height: 100,
                            // width: 70,
                          ),
                        ),
                      ),
                      Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          HeadTitleText(
                            "Weekly Schedule".tr,
                            fontFamily: AppFonts.alatsi,
                            color: Colors.white,
                          ),
                          HeadTitleText(
                            formattedDate.toUpperCase(),
                            fontFamily: AppFonts.alatsi,
                            color: Colors.black,
                          )
                        ],
                      )
                    ],
                  ),
                  SizedBox(
                    width: Get.width,
                    height: Get.height / 6,//143,
                    child: nameDay == 'saturday'
                        ? HeadTitleText(
                            "Today is a Vacation day ....",
                            color: AppColors.newPrimeColor,
                          ).center()
                        : nameDay == 'Friday'
                            ? HeadTitleText(
                                "Today is a Vacation day ....",
                                color: AppColors.newPrimeColor,
                              ).center()
                            : Obx(() {
  final newDailySubject emptySubject = newDailySubject.zero();

  if (newWeeklyController.subjectTableState.loading) {
    return const CircularProgressIndicatorWidget();
  }

  final subjects = newWeeklyController.subjectMap[nameDay]?.subjects ?? [];

  if (subjects.isEmpty) {
    return HeadTitleText(
      "No Lesson's For This Day",
      color: AppColors.newPrimeColor,
    ).center();
  }

  return SizedBox(
    child: ListView.builder(
      scrollDirection: Axis.horizontal,
      itemCount: subjects.length,
      itemBuilder: (BuildContext context, int index) {
        final subject = newWeeklyController.getSubject(nameDay, index);
        print("✅ Subject [$nameDay][$index]: $subject");

        return Padding(
          padding: const EdgeInsets.symmetric(horizontal: 5.0),
          child: ClassWidget(
            newSubjects: subject ?? emptySubject,
            index: index,
          ),
        );
      },
    ),
  ).padding(
    padding: EdgeInsets.symmetric(horizontal: Get.width * 0.05),
  );
})
,
                  )
                ],
              ),
            ).center().padding(padding: EdgeInsets.only(top: Get.height * 0.023)),
          ),
          Padding(
            padding: EdgeInsets.only(left: Get.width * 0.05, right: Get.width * 0.05, bottom: Get.height * 0.023,top: Get.height * 0.023),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                GestureDetector(
                  child: Container(
                    width: Get.width * 0.43,//178,
                    height: Get.height * 0.2,//173,
                    decoration: BoxDecoration(
                        color: const Color.fromRGBO(212, 181, 179, 0.9),
                        borderRadius: BorderRadius.circular(20),
                        boxShadow: const [
                          BoxShadow(
                            color: Color.fromRGBO(181, 181, 181, 1),
                          )
                        ]),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        HeadTitleText(
                          "Boosting Tasks".tr,
                          fontFamily: AppFonts.alatsi,
                          color: AppColors.newPrimeColor,
                        ),
                        SizedBox(height: Get.height * 0.2 / 10),
                        Container(
                          width: Get.width * 0.19 ,//74,
                          height: Get.height * 0.085,//74,
                          decoration: const BoxDecoration(
                            image: DecorationImage(
                              image: AssetImage('asset/images/homeWork.png',)
                            )
                          ),
                        ),
                      ],
                    ),
                  ).center(),
                  onTap: () async {
                    await calenderController.homeworkDelivery(
                      authController.childrens[homeController.selectedChild.value].id,
                      dueFrom: DateTime.now().toString().substring(0, 10),
                    );
                    RoutingManager.to(RoutesName.homeWorkPage);
                  },
                ),
                SizedBox(width: Get.width * 0.04,),
                GestureDetector(
                  child: Container(
                    width: Get.width * 0.42,
                    height: Get.height * 0.2,
                    decoration: BoxDecoration(
                        color: const Color.fromRGBO(217, 217, 217, 0.8),
                        borderRadius: BorderRadius.circular(20),
                        boxShadow: const [
                          BoxShadow(
                            color: Color.fromRGBO(217, 217, 217, 0.8),
                          )
                        ]),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        HeadTitleText(
                          "Exams".tr,
                          fontFamily: 'alatsi',
                          color: AppColors.newPrimeColor,
                        ),
                        SizedBox(height: Get.height * 0.2 / 8),
                        Container(
                          width: Get.width * 0.19 ,//74,
                          height: Get.height * 0.085,//74,
                          decoration: const BoxDecoration(
                              image: DecorationImage(
                                  image: AssetImage('asset/images/exam.png'))),
                        )
                      ],
                    ),
                  ).center(),
                  onTap: () async {
                    await examController.getExams({
                      'registration_record_id': authController
                          .childrens[homeController.selectedChild.value].id,
                      'date_from': DateTime.now(),
                    });
                    await resultController.getExams({
                      'registration_record_id': authController
                          .childrens[homeController.selectedChild.value].id,
                    });
                    RoutingManager.to(RoutesName.mainExamPage);
                  },
                ),
              ],
            ),
          ),
          Padding(
            padding: EdgeInsets.only(left: Get.width * 0.05, right: Get.width * 0.05, bottom: Get.height * 0.023),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                GestureDetector(
                  child: Container(
                    width: Get.width * 0.43,//178,
                    height: Get.height * 0.2,//173,
                    decoration: BoxDecoration(
                        color: const Color.fromRGBO(217, 217, 217, 0.8),
                        borderRadius: BorderRadius.circular(20),
                        boxShadow: const [
                          BoxShadow(
                            color: Color.fromRGBO(217, 217, 217, 0.8),
                          )
                        ]),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        HeadTitleText(
                          "Variable".tr,
                          fontFamily: AppFonts.alatsi,
                          color: AppColors.newPrimeColor,
                        ),
                        SizedBox(height: Get.height * 0.2 / 10),
                        Container(
                          width: Get.width * 0.1 ,//40,
                          height: Get.height * 0.06,//50,
                          decoration: const BoxDecoration(
                              image: DecorationImage(
                                  image: AssetImage('asset/images/variable.png'),
                                  fit: BoxFit.fill)),
                        )
                      ],
                    ),
                  ).center(),
                  onTap: () async {
                    await variableController.getPersonalVariableInfo(reg!, 'registration_record_id');
                    await variableController.getAllVariableInfo(reg!, 'mobile_registration_record');
                    RoutingManager.to(RoutesName.variable);//
                    print('variable');
                  },
                ),
                SizedBox(width: Get.width * 0.04,),
                typeUser == 'parent'
                    ? GestureDetector(
                        child: Container(
                          width: Get.width * 0.42,//173,
                          height: Get.height * 0.2,//173,
                          decoration: BoxDecoration(
                              color: const Color.fromRGBO(212, 181, 179, 0.9),
                              borderRadius: BorderRadius.circular(20),
                              boxShadow: const [
                                BoxShadow(
                                  color: Color.fromRGBO(181, 181, 181, 1),
                                  // spreadRadius: 0,
                                  // blurRadius: 7,
                                )
                              ]),
                          child: Column(
                            mainAxisAlignment: MainAxisAlignment.center,
                            children: [
                              HeadTitleText(
                                "Notes".tr,
                                fontFamily: 'alatsi',
                                color: AppColors.newPrimeColor,
                              ),
                              SizedBox(height: Get.height * 0.2 / 8),
                              Container(
                                width: Get.width * 0.1 ,//40,
                                height: Get.height * 0.06,//50,
                                decoration: const BoxDecoration(
                                    image: DecorationImage(
                                        image:
                                            AssetImage('asset/images/note.png'),
                                        fit: BoxFit.fill)),
                              )
                            ],
                          ),
                        ).center(),
                        onTap: () async {
                          print('note');
                          // await notificationController.getNotifications();
                          RoutingManager.to(RoutesName.notePage);
                        },
                      )
                    : GestureDetector(
                        child: Container(
                          width: Get.width * 0.42,//173,
                          height: Get.height * 0.2,//173,
                          decoration: BoxDecoration(
                              color: const Color.fromRGBO(212, 181, 179, 0.9),
                              borderRadius: BorderRadius.circular(20),
                              boxShadow: const [
                                BoxShadow(
                                  color: Color.fromRGBO(181, 181, 181, 1),
                                )
                              ]),
                          child: Column(
                            mainAxisAlignment: MainAxisAlignment.center,
                            children: [
                              HeadTitleText(
                                'LMS',
                                fontFamily: 'alatsi',
                                color: AppColors.newPrimeColor,
                              ),
                              SizedBox(height: Get.height * 0.2 / 8),
                              Container(
                                width: Get.width * 0.1 ,//40,
                                height: Get.height * 0.06,//50,
                                decoration: const BoxDecoration(
                                    image: DecorationImage(
                                        image:
                                            AssetImage('asset/images/note.png'),
                                        fit: BoxFit.fill)),
                              )
                            ],
                          ),
                        )
                            .center()
                            .padding(padding: EdgeInsets.only(left: isArabic() ? 0 : Get.width * 0.025, right: isArabic() ? Get.width * 0.025 : 0)),//10)),
                        onTap: () async {
                          await calenderController.getSubjects(authController.childrens[homeController.selectedChild.value].id);
                          RoutingManager.to(RoutesName.lmsPage);
                        },
                      ),
              ],
            ),
          )
        ],
      ),
    );
  }

  bool isArabic(){
    String currentLanguageCode = Get.locale.toString();
    if(currentLanguageCode == 'ar'){
      return true;
    }else{
      return false;
    }
  }

}
