import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/home/business_logic/home_controller.dart';
import '../../../../../../features/purchase/purchase_notifier.dart';
import '../../../../../../features/purchase/screens/purchase_screen.dart';
import '../../../../../../features/restaurant/business_logic/restaurant_controller.dart';
import '../../../../../../features/restaurant/presentation/screens/restaurant_screen.dart';

class Food extends StatefulWidget {
  const Food({super.key});
  @override
  State<Food> createState() => _FoodState();
}

class _FoodState extends State<Food> {
  RestaurantController restaurantController = Get.find<RestaurantController>();
  PurchaseNotifier purchaseNotifier = Get.put(PurchaseNotifier());
  AuthController authController = Get.find<AuthController>();
  HomeController homeController = Get.find<HomeController>();
  @override
  void initState() {
    super.initState();
  }
  @override
  Widget build(BuildContext context) {
    return DefaultTabController(
      initialIndex: 1,
      length: 3,
      child: Container(
        decoration: const BoxDecoration(
            color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
            image: DecorationImage(
              image: AssetImage('asset/images/backGroundLogIn1.png'),
              fit: BoxFit.cover)
        ),
        child: const Scaffold(
          backgroundColor: Colors.transparent,
          body: TabBarView(
            children:  <Widget> [
              NestedTabBar('food'),
            ],
          ),
        ),
      ),
    );
  }
}

class NestedTabBar extends StatefulWidget {
  const NestedTabBar(this.outerTab, {super.key});
  final String outerTab;
  @override
  State<NestedTabBar> createState() => _NestedTabBarState();
}

class _NestedTabBarState extends State<NestedTabBar> with TickerProviderStateMixin {
  late final TabController _tabController;
  RestaurantController restaurantController = Get.find<RestaurantController>();
  PurchaseNotifier purchaseNotifier = Get.put(PurchaseNotifier());
  AuthController authController = Get.find<AuthController>();
  HomeController homeController = Get.find<HomeController>();

  Future<void> loadData() async {
    await restaurantController.getStudentMeals();
    await restaurantController.getStudentBalance(authController.childrens[homeController.selectedChild.value].id);
    await restaurantController.getStudentDailyLimit();
    await purchaseNotifier.getBuffetCard(childId: authController.childrens[homeController.selectedChild.value].id);
    await purchaseNotifier.getThisDayPurchase(childId: int.parse(authController.childrens[homeController.selectedChild.value].id),);
  }

  @override
  void initState() {
    super.initState();
    loadData();
    _tabController = TabController(length: 2, vsync: this);
  }

  @override
  void dispose() {
    _tabController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {    
    return Column(
      children: <Widget>[
        Padding(
          padding: EdgeInsets.symmetric(horizontal: MediaQuery.of(context).size.width * 0.05 ,vertical: MediaQuery.of(context).size.width * 0.02 ),
          child: Container(
            height: MediaQuery.of(context).size.height * 0.035,
            decoration: BoxDecoration(
              color: AppColors.newSecondaryColor,
              borderRadius: BorderRadius.circular(20)
            ),
            child: TabBar.secondary(
              labelColor: Colors.white,
              dividerColor: Colors.transparent,
              unselectedLabelColor: AppColors.newPrimeColor,
              indicator: BoxDecoration(
                color: AppColors.newPrimeColor,
                borderRadius: BorderRadius.circular(20)
              ),
              controller: _tabController,
              tabs: <Widget>[
                Tab(
                  child: HeadTitleText(
                    "Restaurant".tr.toUpperCase(),
                    fontFamily: 'alatsi',
                    size: 15,
                  )
                ),
                Tab(
                  child: HeadTitleText(
                    "Buffet".tr.toUpperCase(),
                    fontFamily: 'alatsi',
                    size: 15,
                  )
                ),
              ],
            ),
          ),
        ),
        Expanded(
          child: TabBarView(
            controller: _tabController,
            children: <Widget>[
              RestaurantScreen(),
              PurchaseScreen(),
            ],
          ),
        ),
      ],
    );
  }
}