import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/extensions/widget.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/home/business_logic/home_controller.dart';
import '../../../../../../features/purchase/purchase_notifier.dart';
import '../../../../../../features/restaurant/business_logic/restaurant_controller.dart';

import '../../../../exam/presentation/screens/exam_page.dart';
import '../../../../exam/presentation/screens/result_page.dart';

class MainExamPage extends StatefulWidget {
  const MainExamPage({super.key});

  @override
  State<MainExamPage> createState() => _MainExamPageState();
}

class _MainExamPageState extends State<MainExamPage> {
   RestaurantController restaurantController = Get.find<RestaurantController>();
   
  PurchaseNotifier purchaseNotifier = Get.put(PurchaseNotifier());
  AuthController authController = Get.find<AuthController>();
    HomeController homeController = Get.find<HomeController>();

  Future<void> loadData() async {
  
  }
  @override
  // Widget build(BuildContext context) {
  //   // loadData();
  //   return const DefaultTabController(
  //     initialIndex: 1,
  //     length: 3,
  //     child: Scaffold(
        
  //       body: TabBarView(
  //         children: <Widget>[
  //           NestedTabBar('MainExamPage'),
  //         ],
  //       ),
  //     ),
  //   );
  // }

    Widget build(BuildContext context) {
      // loadData();
    return DefaultTabController(
      initialIndex: 1,
      length: 3,
      child: Container(
        decoration: const BoxDecoration(
            color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
            image: DecorationImage(
                image: AssetImage('asset/images/backGroundLogIn1.png'),
                fit: BoxFit.cover)),
        child: Scaffold(
          backgroundColor: Colors.transparent,
          appBar: AppBar(
            backgroundColor: Colors.transparent,
            leading: IconButton(
              icon: const Icon(Icons.arrow_back),
              color: AppColors.newPrimeColor,
              onPressed: () {
                Navigator.pop(context);
                },
            ),
            title: Center(
              child: HeadTitleText(
                'Exams'.tr.toUpperCase(),
                color: AppColors.newPrimeColor,
                fontFamily: 'alatsi',
              ).padding(
                  padding: EdgeInsets.symmetric(horizontal: Get.width * .18)),
            ),
          ),
          body: const TabBarView(
            children: <Widget>[
              NestedTabBar('MainExamPage'),
            ],
          ),
        ),
      ),
    );
  }

}

class NestedTabBar extends StatefulWidget {
  const NestedTabBar(this.outerTab, {super.key});

  final String outerTab;

  @override
  State<NestedTabBar> createState() => _NestedTabBarState();
}

class _NestedTabBarState extends State<NestedTabBar>
    with TickerProviderStateMixin {
  late final TabController _tabController;

  @override
  void initState() {
    super.initState();
    _tabController = TabController(length: 2, vsync: this);
    
  }

  @override
  void dispose() {
    _tabController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    
    return Column(
      children: <Widget>[
        Padding(
          padding: EdgeInsets.symmetric(horizontal: MediaQuery.of(context).size.width * 0.05 ,vertical: MediaQuery.of(context).size.width * 0.02 ),
          child: Container(
            height: MediaQuery.of(context).size.height * 0.045,
            decoration: BoxDecoration(
                color: AppColors.newSecondaryColor,
                borderRadius: BorderRadius.circular(20)
            ),
            child: TabBar.secondary(
              labelColor: Colors.white,
              unselectedLabelColor: AppColors.newPrimeColor,
              dividerColor: Colors.transparent,
              indicator: BoxDecoration(
                  color: AppColors.newPrimeColor,
                  borderRadius: BorderRadius.circular(20)
              ),
              controller: _tabController,
              tabs: <Widget>[
                Tab(
                    child: HeadTitleText(
                      "Exams".tr,
                      fontFamily: 'alatsi',
                      // color: Color(0xffA5302B),
                      size: 15,
                    )),
                Tab(
                    child: HeadTitleText(
                      "Results".tr,
                      fontFamily: 'alatsi',
                      // color: Color(0xffA5302B),
                      size: 15,
                    )),
              ],
            ),
          ),
        ),
        Expanded(
          child: TabBarView(
            controller: _tabController,
            children: <Widget>[
              ExamPage(),
              ResultPage(),
            ],
          ),
        ),
      ],
    );
  }
}