import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../../core/local%20storage/local_storage.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/home/business_logic/home_controller.dart';

import '../../../../common/constant/colors.dart';
import '../../../../common/extensions/widget.dart';
import '../../../../common/widgets/text.dart';
import '../../../calender/business_logic/calender_controller.dart';

class AppBarHomePage extends StatelessWidget implements PreferredSizeWidget {
  AppBarHomePage({super.key});
  @override
  Size get preferredSize => const Size.fromHeight(90);
  AuthController authController = Get.find<AuthController>();
  HomeController homeController = Get.find<HomeController>();
  CalenderController calenderController = Get.find<CalenderController>();
  LocalStorage storage = LocalStorage();
  @override
  Widget build(BuildContext context) {
    return Container(
      color: AppColors.primeColor,
      alignment: Alignment.centerRight,
      child: Padding(
        padding: const EdgeInsets.symmetric(horizontal: 30),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Obx(() {
              return HeadTitleText(
                authController
                    .childrens[homeController.selectedChild.value].name,
                // TODO: should be a prameter to this widget
              ).padding(padding: const EdgeInsets.only(top: 30)).expanded(2);
            }),
            Obx(() {
              return CircleAvatar(
                      radius: 30,
                      backgroundImage: authController
                              .childrens[homeController.selectedChild.value]
                              .photo!
                              .isNotEmpty
                          ? NetworkImage(authController
                              .childrens[homeController.selectedChild.value]
                              .photo!)
                          : authController
                                      .childrens[
                                          homeController.selectedChild.value]
                                      .gender ==
                                  "male"
                              ? const AssetImage('asset/images/Profile-Boy.png')
                              : const AssetImage(
                                      "asset/images/Profile-Girl.png")
                                  as ImageProvider)
                  .padding(
                padding: const EdgeInsets.only(top: 30),
              );
            })
          ],
        ),
      ),
    );
  }
}
