import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:get/get.dart';

import '../../../../common/extensions/widget.dart';
import '../../../../common/widgets/text.dart';

class HorizontalHomeWidget extends StatelessWidget {
  final String icon;
  final String title;
  final Color backGroundColor;
  final Color borderColor;
  final Color bigBorderColor;
  final Widget child;
  final String? subTitle;
  final double? height;
  const HorizontalHomeWidget(
      {super.key,
      required this.child,
      required this.backGroundColor,
      required this.bigBorderColor,
      required this.borderColor,
      required this.icon,
      required this.title,
      this.subTitle,
      this.height});

  @override
  Widget build(BuildContext context) {
    return Column(
        children: [
          Container(
        height: Get.height * 0.05,
        width: Get.width * 0.88,//361,
        decoration: BoxDecoration(
          color: backGroundColor,
          borderRadius: const BorderRadius.only(
            topLeft: Radius.circular(10),
            topRight: Radius.circular(10),
          ),
          border: Border.all(color: borderColor),
        ),
        child: Row(
          children: [
            InkWell(
                child: SvgPicture.asset(
              'asset/icons/$icon',
              color: Colors.white,
            )).padding(padding: const EdgeInsets.only(left: 20, right: 20)),
            HeadTitleText(title),
            const SizedBox(width: 30),
            NormalText(subTitle ?? '')
          ],
        ),
      ),
          Container(
              width: Get.width * 0.88,//361,
              height: Get.height * 0.15,//227,
              decoration: BoxDecoration(
                  color: Colors.white,
                  borderRadius: const BorderRadius.only(
                      bottomLeft: Radius.circular(10),
                      bottomRight: Radius.circular(10)),
                  border: Border.all(color: bigBorderColor)),
              child: child)
    ]);
  }
}
