import 'package:flutter/material.dart';
import 'package:intl/intl.dart';

import '../../../../../../common/extensions/widget.dart';
import '../../../../../../features/restaurant/data/model/meal.dart';

import '../../../../common/constant/colors.dart';
import '../../../../common/constant/domain.dart';
import '../../../../common/widgets/text.dart';
import 'package:get/get.dart';

import '../../../auth/business_logic/auth_controller.dart';
import '../../business_logic/home_controller.dart';
import '../../../../../../common/extensions/date.dart';
// class RestaurantBodyMiddleware extends GetMiddleware {
//   @override
//   Widget onPageBuilt(Widget page) {

//     final AuthController authController = Get.find<AuthController>();
//     final HomeController homeController = Get.find<HomeController>();

//     homeController.setRegistrationRecord(
//       authController.childrens[homeController.selectedChild.value].id,
//     );
//     WidgetsBinding.instance.addPostFrameCallback((_) async {
//       await homeController.getLatestMeals();
//     });

//     return super.onPageBuilt(page);
//   }
// }
// class ResurantBodyMiddleware extends GetMiddleware {
//   @override
//   Widget onPageBuilt(Widget page) {
//     // TODO: implement onPageBuilt
//     HomeController homeController = Get.find<HomeController>();
//     AuthController authController = Get.find<AuthController>();
//     WidgetsBinding.instance.addPostFrameCallback((timeStamp) async {
//       await homeController.getLatestMeal(
//           authController.childrens[homeController.selectedChild.value].id);
//     });
//     return super.onPageBuilt(page);
//   }
// }

class RestaurantBody extends StatelessWidget {
  HomeController homeController = Get.find<HomeController>();
  AuthController authController = Get.find<AuthController>();
  final MealClass mealClass;

  RestaurantBody({super.key, required this.mealClass});

  @override
  Widget build(BuildContext context) {
    // homeController.getLatestMeal(
    //     authController.childrens[homeController.selectedChild.value].id);
    String words = mealClass.image;
    List<String> wordL = words.split("/");
    String image = wordL.sublist(1, wordL.length).join("/");

    return Column(
      children: [
        NormalText(
          DateTime.parse(DateFormat('yyyy-MM-dd').format(DateTime.now()))
              .toDay()
              .tr,
          // homeController.getLatestMealState.result.isEmpty
          //     ? ''
          //     : homeController
          //         .getLatestMealState.result[0].meal.days[0].tr, //TODO: api
          textColor: Colors.black45,
        ),
        TextTitle(
          mealClass.name.isEmpty
              ? 'not selected yet'.tr
              : mealClass.name.tr, //TODO: api
          textColor: Colors.black45,
        ).padding(padding: const EdgeInsets.only(top: 5)),
        CircleAvatar(
          radius: 44,
          backgroundColor: AppColors.appGreen,
          child: CircleAvatar(
            backgroundColor: Colors.white,
            radius: 43,
            backgroundImage:
                homeController.getLatestMealState.result.meal.image.isEmpty
                    ? const AssetImage('asset/images/meal.png')
                    : NetworkImage('${Domain.domain}storage/$image')
                        as ImageProvider,
          ),
        )
      ],
    );
  }
}
