import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:get/get.dart';

import '../../../../common/extensions/widget.dart';
import '../../../../common/widgets/text.dart';

class VerticalHomeWidget extends StatelessWidget {
  final String title;
  final Widget child;
  final String icon;
  final Color backGroundColor;
  final Color borderColor;
  final Color bigBorderColor;
  const VerticalHomeWidget(
      {super.key,
      required this.child,
      required this.title,
      required this.icon,
      required this.borderColor,
      required this.backGroundColor,
      required this.bigBorderColor});

  @override
  Widget build(BuildContext context) {
    return Column(children: [
      Container(
        // color: Colors.black,
        height: 50,
        width: Get.width * .42,
        decoration: BoxDecoration(
            color: backGroundColor,
            borderRadius: const BorderRadius.only(
                topLeft: Radius.circular(10), topRight: Radius.circular(10)),
            border: Border.all(color: borderColor)),
        child: Row(
          children: [
            TextTitle(
              title,
              textColor: Colors.white,
            ).center().expanded(3),
            Container(
              alignment: Alignment.centerRight,
              child: InkWell(
                  child: SvgPicture.asset(
                icon,
                color: Colors.white,
              )).padding(padding: const EdgeInsets.only(right: 10)),
            ).expanded(1)
          ],
        ),
      ),
      Container(
        height: 160,
        width: MediaQuery.of(context).size.width * .42,
        decoration: BoxDecoration(
            color: Colors.white,
            borderRadius: const BorderRadius.only(
                bottomLeft: Radius.circular(10),
                bottomRight: Radius.circular(10)),
            border: Border.all(color: bigBorderColor)),
        child: child,
      )
    ]);
  }
}
