import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/extensions/widget.dart';
import '../../../../../../common/widgets/Empty_view.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/calender/business_logic/calender_controller.dart';
import '../../../../../../features/class/presentation/widgets/home_work_widget.dart';
import '../../../../../../features/home/business_logic/home_controller.dart';

class HomeworkPage extends StatefulWidget {
  const HomeworkPage({super.key});
  @override
  State<HomeworkPage> createState() => _HomeworkPageState();
}

class _HomeworkPageState extends State<HomeworkPage> {
  CalenderController calenderController = Get.put(CalenderController());
  AuthController authController = Get.find<AuthController>();
  HomeController homeController = Get.find<HomeController>();

  loadData() async{
    await calenderController.homeworkDelivery(
      authController.childrens[homeController.selectedChild.value].id,
      dueFrom: DateTime.now().toString().substring(0, 10),
    );
  }

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    // loadData();
  }

  @override
  Widget build(BuildContext context) {
    //  notificationController.getNotifications();
    return Container(
      decoration: const BoxDecoration(
          color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
          image: DecorationImage(
              image: AssetImage('asset/images/backGroundLogIn1.png'),
              fit: BoxFit.cover)),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        appBar: AppBar(
          scrolledUnderElevation: 0,
          backgroundColor: Colors.transparent,
          leading: IconButton(
            icon: const Icon(Icons.arrow_back),
            color: AppColors.newPrimeColor,
            onPressed: () {
              Navigator.pop(context);
            },
          ),
          title: Center(
            child: HeadTitleText(
              'Homework'.tr.toUpperCase(),
              color: AppColors.newPrimeColor,
              fontFamily: 'alatsi',
            ).padding(padding: const EdgeInsets.only(right: 50, bottom: 10)),
          ),
        ),
        body: SingleChildScrollView(
          child: Column(
            children: [
              Padding(
                padding: const EdgeInsets.symmetric(horizontal: 0),
                child: SizedBox(
                    height: Get.height,
                    width: Get.width,
                    child: Obx(() {
                      return  calenderController.homeworkDeliveryState.loading
                          ? Center(child: CircularProgressIndicator(
                        backgroundColor: AppColors.quizItem,
                        color: AppColors.newPrimeColor,
                      ))
                          : calenderController.homeworkDeliveryState.result.isEmpty
                          ? Padding(
                        padding: EdgeInsets.symmetric(vertical: Get.height * .2),
                        child: const EmptyView(),
                      )
                          : GridView.builder(
                          shrinkWrap: true,
                          physics: const NeverScrollableScrollPhysics(),
                          itemCount: calenderController.homeworkDeliveryState.result
                              .length ,
                          gridDelegate:
                          const SliverGridDelegateWithFixedCrossAxisCount(
                              crossAxisCount: 3,
                              childAspectRatio: 0.56),
                          itemBuilder: (BuildContext context, index) {
                            return HomeWorkWidget(
                              date: calenderController
                                  .homeworkDeliveryState
                                  .result[index]
                                  .dueTo,
                              homeWorkModel: calenderController
                                  .homeworkDeliveryState.result[index],
                            );
                          }
                      );
                    }
                    )
                    ),
              )
            ],
          ),
        ),
      ),
    );
  }
}


/*
GridView.count(
                            childAspectRatio: 450 / 500,
                            crossAxisCount: 2,
                            shrinkWrap: true,
                            children: List.generate(
                                calenderController.homeworkDeliveryState.result
                                    .length, (index) {
                              return SizedBox(
                                  height: 500,
                                  width: 500,
                                  child: HomeWorkWidget(
                                      color: AppColors.primeColor,
                                      homeWorkModel: calenderController
                                          .homeworkDeliveryState.result[index],
                                      date: calenderController
                                          .homeworkDeliveryState
                                          .result[index]
                                          .dueTo));
                            }))
 */