import 'package:get/get.dart';
import '../../../../../common/widgets/snack_bar_widget.dart';
import 'package:rx_future/rx_future.dart';
import '../../../../../features/calender/data/models/subject_response.dart';
import '../../../../../features/calender/data/services/subjects_service.dart';
import '../../../../../features/lms/data/model/lmsCompletedResponse.dart';
import '../../../../../features/lms/data/model/lmsResponse.dart';
import '../../../../../features/lms/data/service/lms_service.dart';

class LmsController extends GetxController {

  RxFuture<List<LmsResponse>> lmsState = RxFuture([]);

  RxFuture<List<LmsCompletedResponse>> lmsCompletedState = RxFuture([]);


  RxFuture<List<SubjectResponse>> subjectState = RxFuture([]);
  SubjectService subjectService = SubjectService();
  LmsService lmsService = LmsService();


  Future<void> getLmsQuiz(String subjectId, String regsId) async {
    await lmsState.observe(
            (_) async {
              print('lms quiz observe lms quiz observe lms quiz observe lms quiz observe ');
              return lmsService.getQuiz(subjectId,regsId);
        },
        onError: (p0) {
          print('Error from getLmsQuiz in LmsController');
          snackBarWidget('something wrong', p0.toString());
        }
    );
  }

  Future<void> getLmsCompleted(String subjectId, String regsId) async{
    await lmsCompletedState.observe(
        (_) async {
          print('lms quiz observe from getLmsCompleted ');
          return lmsService.getQuizCompleted(subjectId, regsId);
        },
      onError: (p0){
          print('Error from getLmsCompleted in LmsController');
          snackBarWidget('something wrong', p0.toString());
      }
    );
  }





  Future<void> getSubjects(String gradeId) async {
    await subjectState.observe(
          (_) async {
        return subjectService.getSubjects(gradeId);
      },
      onError: (p0) {
        snackBarWidget('something wrong', p0.toString());
      },
    );
  }




  // RxFuture<List<LmsSubjectResponse>> lmsState = RxFuture([]);
  // RxFuture<List<SubjectResponse>> subjectState = RxFuture([]);
  // LmsService lmsService = LmsService();
  // SubjectService subjectService = SubjectService();
  // Future<void> getSubjects(String gradeId) async {
  //   await subjectState.observe(
  //     (_) async {
  //       return await subjectService.getSubjects(gradeId);
  //     },
  //     onError: (p0) {
  //       snackBarWidget('something wrong', p0.toString());
  //     },
  //   );
  // }
}
