import 'package:get/get.dart';
import '../../../../../common/widgets/snack_bar_widget.dart';
import 'package:rx_future/rx_future.dart';
import '../../../../../features/lms/data/model/quizModel.dart';
import '../../../../../features/lms/data/model/studentQuizModel.dart';
import '../../../../../features/lms/data/service/quizService.dart';
import '../../../../../features/purchase/api_res.dart';

class QuizController extends GetxController {

  RxFuture<QuizModel> quizState = RxFuture(QuizModel.zero());

  RxFuture<StudentQuizModel> quizDetailState = RxFuture(StudentQuizModel.zero());

  QuizService quizService = QuizService();

  String studentQuizId = '';
  var studentIdQuiz ;


  Future<void> getQuizInfo(String quizId) async{
    await quizState.observe(
            (_) async {
          return quizService.getQuizInfo(quizId);
        },
        onError: (p0) {
          snackBarWidget('somthing wrong', p0.toString());
        }
    );
  }


  Future<int> updateQuizInfo({required List<Map<String, dynamic>> data, required String quizId}) async {
    ApiResponse apiResponse = await quizService.sendQuizData(
      quizId: quizId,
      body: data
    );

    if(apiResponse.errorMessage != null){
      snackBarWidget('Something is wrong', apiResponse.errorMessage.toString());
      return 0;
    }else{
      print('*********************** This Message is from QUIZ CONTROLLER CLASS ***********************');
      print('done');
      // studentQuizId = apiResponse.data['id'].toString();
      studentIdQuiz = apiResponse.data['id'];
      print(apiResponse.data);
      print(apiResponse.data['id']);
      // print(studentQuizId);
      print(studentIdQuiz);
      print('*********************** This Message is from QUIZ CONTROLLER CLASS ***********************');
      snackBarWidget('Success'.toUpperCase(), 'The Answer is save');
      return apiResponse.data['id'];
    }
  }


  Future<void> getQuizReport(var studentId) async{
    print('klklklklklklklklklklklklklklklklklklklkl');
    // print(studentQuizId);
    await quizDetailState.observe(
        (_) async {
          print('kinan kinan kinan 1 1 1');
          return quizService.getDetailReport(studentId);
        },
      onError: (p0){
          print(p0.toString());
          print('kinan kinan kinan 2 2 2');
          snackBarWidget('something wrong', p0.toString());
      }
    );
  }
}