
import 'package:intl/intl.dart';

class LmsCompletedResponse {

  LmsCompletedResponse({
    required this.id,
    required this.quiz,
    required this.user,
    required this.student,
    required this.eduClass,
    required this.result,
    required this.attemptNum,
    // required this.percent,
    required this.resultPercent,
    required this.date,
    this.body
  });


  String id;
  String quiz;
  String user;
  String student;
  String eduClass;
  String result;
  int resultPercent;
  int attemptNum;
  // int percent;
  String? body;
  DateTime date;


  factory LmsCompletedResponse.fromJson(Map<String, dynamic> json) =>
      LmsCompletedResponse(
        id: json["id"].toString(),
        quiz: json["quiz"],
        user: json['user'],
        student: json['student'],
        eduClass: json['edu_class'],
        result: json['result'],
        attemptNum: json['attempt_number'],
        // percent: json['percent'],
        resultPercent: json['result_percent'].round(),
        date: convertToDateTime(json["date"]),
        body: json['body'] ?? '',
      );

  //DateFormat('d MMM y').format(DateTime.now())
  factory LmsCompletedResponse.zero() => LmsCompletedResponse(
    id: '',
    quiz: '',
    user: '',
    student: '',
    eduClass: '',
    result: '',
    attemptNum: 0,
    // percent: 0,
    resultPercent: 0,
    date: DateTime.now(),
  );

  static List<LmsCompletedResponse> fromJsonList(
      Map<String, dynamic> json,
      String key,
      ) {
    List<LmsCompletedResponse> completedQuiz = [];
    try{
      if (json[key] == null) {
        return [];
      }
      json[key].forEach(
            (q) => completedQuiz.add(
          LmsCompletedResponse.fromJson(q),
        ),
      );
    } catch (e) {
      print('Error from Lms Completed Response Error from Lms Completed Response Error from Lms Completed Response');
      print(e);
    }
    return completedQuiz;
  }


  static DateTime convertToDateTime(String date) {
    DateFormat dateFormat = DateFormat('yyyy-MM-dd');
    // DateFormat dateFormat = DateFormat('d MMM y');
    DateTime s = dateFormat.parse(date);

    // String ss = DateFormat('d MMM y').format(s);

    return s;
  }

}