import 'package:intl/intl.dart';
import '../../../../../features/lms/data/model/questionModel.dart';

class QuizModel {

  QuizModel({
    required this.id,
    required this.name,
    required this.activateDate,
    required this.time,
    required this.repeatNumber,
    required this.attemptNumber,
    required this.totalResult,
    required this.questionNumber,
    required this.questions,
    this.body
  });

  String id;
  String name;
  DateTime activateDate;
  int time;
  int repeatNumber;
  int attemptNumber;
  int questionNumber;
  int totalResult;
  List<QuestionModel> questions;
  String? body;

  factory QuizModel.zero() =>
  QuizModel(
      id: '',
      name: '',
      activateDate: DateTime.now(),
      time: 0,
      repeatNumber: 0,
      attemptNumber: 0,
      totalResult: 0,
      questionNumber: 0,
      questions: []
  );

  factory QuizModel.fromJson(Map<String, dynamic> json) =>
      QuizModel(
        id: json["id"].toString(),
        name: json["name"],
        activateDate: convertToDateTime(json["activate_date"]),
        time: json["time"],
        repeatNumber: json["repeat_number"],
        attemptNumber: json["attempt_number"],
        totalResult: json["total_result"],
        questionNumber: json["question_number"],
        questions: fromJsonList(json, "questions")
      );

  static List<QuestionModel> fromJsonList(
      Map<String, dynamic> json,
      String key
      ){
    List<QuestionModel> questions = [];
    try{
      if(json[key] == null){
        return [];
      }
      json[key].forEach(
          (q) => questions.add(
           QuestionModel.fromJson(q),
          )
      );
    } catch (e){
      print('Error from Quiz Model Error from Quiz Model Error from Quiz Model');
      print(e);
    }
    return questions;
  }



  static DateTime convertToDateTime(String date) {
    DateFormat dateFormat = DateFormat('yyyy-MM-dd');
    DateTime s = dateFormat.parse(date);

    return s;
  }


}