class ReportDetailResponse {

  ReportDetailResponse({
    required this.question,
    required this.answer,
    required this.correctAnswer,
    required this.mark,
    required this.comment,
    required this.isCorrect,
    this.body,
  });

  String question;
  String answer;
  String correctAnswer;
  int mark;
  String comment;
  String? body;
  bool isCorrect;

  factory ReportDetailResponse.zero() => ReportDetailResponse(
      question: '', answer: '', correctAnswer: '', mark: 0, comment: '', isCorrect: false);


  factory ReportDetailResponse.fromJson(Map<String, dynamic> json) =>
      ReportDetailResponse(
          question: json['question'],
          answer: json['answer'],
          correctAnswer: json['correct_answer'],
          mark: json['mark'],
          comment: json['comment'],
          isCorrect: (json['answer'] == json['correct_answer'])
      );


  static List<ReportDetailResponse> fromJsonList(
      Map<String, dynamic> json,
      String key
      ){
    List<ReportDetailResponse> list = [];
    try{
      if(json[key] == null){
        return [];
      }
      json[key].forEach(
              (q) => list.add(
                ReportDetailResponse.fromJson(q),
          )
      );
    } catch (e){
      print('Error from Report Detail Response Error from Report Detail Response Error from Report Detail Response');
      print(e);
    }

    return list;
  }
}
